/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XsContentDFA
extends XmlContentDFA {
    private final XSCMValidator myContentModel;
    private final SubstitutionGroupHandler myHandler;
    private final int[] myState;
    private final XmlElementDescriptor[] myElementDescriptors;

    @Nullable
    public static XmlContentDFA createContentDFA(@NotNull XmlTag parentTag) {
        if (parentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentTag", "com/intellij/psi/impl/source/xml/XsContentDFA", "createContentDFA"));
        }
        final PsiFile file = parentTag.getContainingFile().getOriginalFile();
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XSModel xsModel = (XSModel)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<XSModel>(){

            public XSModel compute() {
                return XsContentDFA.getXSModel((XmlFile)file);
            }
        });
        if (xsModel == null) {
            return null;
        }
        XSElementDeclaration decl = XsContentDFA.getElementDeclaration(parentTag, xsModel);
        if (decl == null) {
            return null;
        }
        return new XsContentDFA(decl, parentTag);
    }

    public XsContentDFA(@NotNull XSElementDeclaration decl, final XmlTag parentTag) {
        if (decl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/impl/source/xml/XsContentDFA", "<init>"));
        }
        XSComplexTypeDecl definition = (XSComplexTypeDecl)decl.getTypeDefinition();
        this.myContentModel = definition.getContentModel(new CMBuilder(new CMNodeFactory()));
        this.myHandler = new SubstitutionGroupHandler((XSElementDeclHelper)new MyXSElementDeclHelper());
        this.myState = this.myContentModel.startContentModel();
        this.myElementDescriptors = (XmlElementDescriptor[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<XmlElementDescriptor[]>(){

            public XmlElementDescriptor[] compute() {
                XmlElementDescriptor parentTagDescriptor = parentTag.getDescriptor();
                assert (parentTagDescriptor != null);
                return parentTagDescriptor.getElementsDescriptors(parentTag);
            }
        });
    }

    @Override
    public List<XmlElementDescriptor> getPossibleElements() {
        Vector vector = this.myContentModel.whatCanGoHere(this.myState);
        ArrayList<XmlElementDescriptor> list = new ArrayList<XmlElementDescriptor>();
        for (Object o : vector) {
            if (!(o instanceof XSElementDecl)) continue;
            final XSElementDecl elementDecl = (XSElementDecl)o;
            XmlElementDescriptor descriptor = (XmlElementDescriptor)ContainerUtil.find((Object[])this.myElementDescriptors, (Condition)new Condition<XmlElementDescriptor>(){

                public boolean value(XmlElementDescriptor elementDescriptor) {
                    return elementDecl.getName().equals(elementDescriptor.getName());
                }
            });
            ContainerUtil.addIfNotNull((Object)descriptor, list);
        }
        return list;
    }

    @Override
    public void transition(XmlTag xmlTag) {
        this.myContentModel.oneTransition(XsContentDFA.createQName(xmlTag), this.myState, this.myHandler);
    }

    private static QName createQName(XmlTag tag) {
        String namespace = tag.getNamespace();
        return new QName(tag.getNamespacePrefix().intern(), tag.getLocalName().intern(), tag.getName().intern(), namespace.isEmpty() ? null : namespace.intern());
    }

    @Nullable
    private static XSElementDeclaration getElementDeclaration(XmlTag tag, XSModel xsModel) {
        ArrayList<XmlTag> ancestors = new ArrayList<XmlTag>();
        for (XmlTag t = tag; t != null; t = t.getParentTag()) {
            ancestors.add(t);
        }
        Collections.reverse(ancestors);
        XSElementDeclaration declaration = null;
        SubstitutionGroupHandler fSubGroupHandler = new SubstitutionGroupHandler((XSElementDeclHelper)new MyXSElementDeclHelper());
        CMBuilder cmBuilder = new CMBuilder(new CMNodeFactory());
        block1: for (XmlTag ancestor : ancestors) {
            if (declaration == null) {
                declaration = xsModel.getElementDeclaration(ancestor.getLocalName(), ancestor.getNamespace());
                if (declaration != null) continue;
                return null;
            }
            XSTypeDefinition typeDefinition = declaration.getTypeDefinition();
            if (!(typeDefinition instanceof XSComplexTypeDecl)) {
                return null;
            }
            XSCMValidator model = ((XSComplexTypeDecl)typeDefinition).getContentModel(cmBuilder);
            int[] ints = model.startContentModel();
            for (XmlTag subTag : ancestor.getParentTag().getSubTags()) {
                QName qName = XsContentDFA.createQName(subTag);
                Object o = model.oneTransition(qName, ints, fSubGroupHandler);
                if (subTag != ancestor) continue;
                if (o instanceof XSElementDecl) {
                    declaration = (XSElementDecl)o;
                    continue block1;
                }
                return null;
            }
        }
        return declaration;
    }

    @Nullable
    private static XSModel getXSModel(XmlFile file) {
        ValidateXmlActionHandler handler2 = new ValidateXmlActionHandler(false){

            @Override
            protected SAXParser createParser() throws SAXException, ParserConfigurationException {
                SAXParser parser = super.createParser();
                parser.getXMLReader().setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                return parser;
            }
        };
        handler2.setErrorReporter(new ErrorReporter(handler2){
            int count;

            @Override
            public void processError(SAXParseException ex, ValidateXmlActionHandler.ProblemType warning) throws SAXException {
                if (warning != ValidateXmlActionHandler.ProblemType.WARNING && this.count++ > 100) {
                    throw new SAXException(ex);
                }
            }

            @Override
            public boolean isUniqueProblem(SAXParseException e) {
                return true;
            }
        });
        handler2.doValidate(file);
        XMLGrammarPool grammarPool = ValidateXmlActionHandler.getGrammarPool(file);
        if (grammarPool == null) {
            return null;
        }
        Object[] grammars = grammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        return grammars.length == 0 ? null : ((XSGrammar)grammars[0]).toXSModel((XSGrammar[])ContainerUtil.map((Object[])grammars, (Function)new Function<Grammar, XSGrammar>(){

            public XSGrammar fun(Grammar grammar) {
                return (XSGrammar)grammar;
            }
        }, (Object[])new XSGrammar[0]));
    }

    private static class MyXSElementDeclHelper
    implements XSElementDeclHelper {
        private final XSGrammarBucket myBucket = new XSGrammarBucket();

        private MyXSElementDeclHelper() {
        }

        public XSElementDecl getGlobalElementDecl(QName name) {
            SchemaGrammar grammar = this.myBucket.getGrammar(name.uri);
            return grammar == null ? null : grammar.getGlobalElementDecl(name.localpart, name.prefix);
        }
    }
}

