/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@State(name="TemplateDataLanguageMappings", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/templateLanguages.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class TemplateDataLanguageMappings
extends LanguagePerFileMappings<Language> {
    public static TemplateDataLanguageMappings getInstance(Project project) {
        return (TemplateDataLanguageMappings)((Object)ServiceManager.getService((Project)project, TemplateDataLanguageMappings.class));
    }

    public TemplateDataLanguageMappings(Project project) {
        super(project);
    }

    protected String serialize(Language language) {
        return language.getID();
    }

    public List<Language> getAvailableValues() {
        return TemplateDataLanguageMappings.getTemplateableLanguages();
    }

    public Language getDefaultMapping(@Nullable VirtualFile file) {
        return file == null ? null : TemplateDataLanguagePatterns.getInstance().getTemplateDataLanguageByFileName(file);
    }

    public static List<Language> getTemplateableLanguages() {
        return ContainerUtil.findAll((Collection)Language.getRegisteredLanguages(), (Condition)new Condition<Language>(){

            public boolean value(Language language) {
                if (language == Language.ANY) {
                    return false;
                }
                if (language instanceof TemplateLanguage || language instanceof DependentLanguage || language instanceof InjectableLanguage) {
                    return false;
                }
                if (language.getBaseLanguage() != null) {
                    return this.value(language.getBaseLanguage());
                }
                return true;
            }
        });
    }
}

