/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeSignatureGestureDetector;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureHandler
implements ChangeSignatureHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        JavaChangeSignatureHandler.invokeOnElement(project, editor, element);
    }

    private static void invokeOnElement(Project project, Editor editor, PsiElement element) {
        if (element instanceof PsiMethod) {
            ChangeSignatureGestureDetector detector = ChangeSignatureGestureDetector.getInstance(project);
            PsiIdentifier nameIdentifier = ((PsiMethod)element).getNameIdentifier();
            if (nameIdentifier != null && detector.isChangeSignatureAvailable(element)) {
                detector.changeSignature(element.getContainingFile(), false);
                return;
            }
            JavaChangeSignatureHandler.invoke((PsiMethod)element, project, editor);
        } else if (element instanceof PsiClass) {
            JavaChangeSignatureHandler.invoke((PsiClass)element, editor);
        } else {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        JavaChangeSignatureHandler.invokeOnElement(project, editor, elements[0]);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name");
    }

    private static void invoke(PsiMethod method, Project project, @Nullable Editor editor) {
        PsiMethod newMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
        if (newMethod == null) {
            return;
        }
        if (!newMethod.equals(method)) {
            ChangeSignatureUtil.invokeChangeSignatureOn(newMethod, project);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiReferenceExpression refExpr = editor != null ? JavaTargetElementEvaluator.findReferenceExpression(editor) : null;
        boolean allowDelegation = containingClass != null && (!containingClass.isInterface() || PsiUtil.isLanguageLevel8OrHigher((PsiElement)containingClass));
        JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(project, method, allowDelegation, (PsiElement)(refExpr == null ? method : refExpr));
        dialog.show();
    }

    private static void invoke(PsiClass aClass, Editor editor) {
        PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
        Project project = aClass.getProject();
        if (typeParameterList == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"changeClassSignature.no.type.parameters"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"change.class.signature.dialog");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        ChangeClassSignatureDialog dialog = new ChangeClassSignatureDialog(aClass, true);
        dialog.show();
    }

    @Nullable
    public PsiElement findTargetMember(PsiFile file, Editor editor) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return this.findTargetMember(element);
    }

    public PsiElement findTargetMember(PsiElement element) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiReferenceParameterList referenceParameterList;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterList.class) != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        }
        PsiTypeParameterList typeParameterList = (PsiTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeParameterList.class);
        if (typeParameterList != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)typeParameterList, PsiMember.class);
        }
        PsiElement elementParent = element.getParent();
        if (elementParent instanceof PsiMethod && ((PsiMethod)elementParent).getNameIdentifier() == element) {
            PsiClass containingClass = ((PsiMethod)elementParent).getContainingClass();
            if (containingClass != null && containingClass.isAnnotationType()) {
                return null;
            }
            return elementParent;
        }
        if (elementParent instanceof PsiClass && ((PsiClass)elementParent).getNameIdentifier() == element) {
            if (((PsiClass)elementParent).isAnnotationType() || ((PsiClass)elementParent).isEnum()) {
                return null;
            }
            return elementParent;
        }
        PsiCallExpression expression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCallExpression.class);
        if (expression != null) {
            Object qualifierExpression = expression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression() : (expression instanceof PsiNewExpression ? ((PsiNewExpression)expression).getQualifier() : null);
            if (PsiTreeUtil.isAncestor((PsiElement)qualifierExpression, (PsiElement)element, (boolean)false)) {
                PsiElement parent;
                PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)qualifierExpression, PsiExpressionList.class);
                if (expressionList != null && (parent = expressionList.getParent()) instanceof PsiCallExpression) {
                    return ((PsiCallExpression)parent).resolveMethod();
                }
            } else {
                return expression.resolveMethod();
            }
        }
        if ((referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceParameterList.class)) != null && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiJavaCodeReferenceElement.class)) != null) {
            PsiElement resolved = referenceElement.resolve();
            if (resolved instanceof PsiClass) {
                return resolved;
            }
            if (resolved instanceof PsiMethod) {
                return resolved;
            }
        }
        return null;
    }
}

