/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.Nullable;

public class OverriderUsageInfo
extends UsageInfo {
    private final PsiMethod myBaseMethod;
    private final boolean myToInsertArgs;
    private final boolean myToCatchExceptions;
    private final boolean myIsOriginalOverrider;
    private final PsiMethod myOverridingMethod;

    public OverriderUsageInfo(PsiMethod method, PsiMethod baseMethod, boolean isOriginalOverrider, boolean toInsertArgs, boolean toCatchExceptions) {
        super((PsiElement)method);
        this.myOverridingMethod = method;
        this.myBaseMethod = baseMethod;
        this.myToInsertArgs = toInsertArgs;
        this.myToCatchExceptions = toCatchExceptions;
        this.myIsOriginalOverrider = isOriginalOverrider;
    }

    public PsiMethod getBaseMethod() {
        return this.myBaseMethod;
    }

    public PsiMethod getOverridingMethod() {
        return this.myOverridingMethod;
    }

    @Nullable
    public PsiMethod getElement() {
        PsiElement element = super.getElement();
        return element instanceof PsiMethod ? (PsiMethod)element : this.myOverridingMethod;
    }

    public boolean isOriginalOverrider() {
        return this.myIsOriginalOverrider;
    }

    public boolean isToCatchExceptions() {
        return this.myToCatchExceptions;
    }

    public boolean isToInsertArgs() {
        return this.myToInsertArgs;
    }
}

