/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveAllClassesInFileHandler;
import com.intellij.util.ArrayUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MoveJavaClassesInFileHandler
extends MoveAllClassesInFileHandler {
    @Override
    public void processMoveAllClassesInFile(@NotNull Map<PsiClass, Boolean> allClasses, PsiClass psiClass, PsiElement ... elementsToMove) {
        if (allClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allClasses", "com/intellij/refactoring/move/moveClassesOrPackages/MoveJavaClassesInFileHandler", "processMoveAllClassesInFile"));
        }
        if (psiClass instanceof LightClass) {
            return;
        }
        PsiClassOwner containingFile = (PsiClassOwner)psiClass.getContainingFile();
        PsiClass[] classes = containingFile.getClasses();
        boolean all = true;
        for (PsiClass aClass : classes) {
            if (ArrayUtil.find((Object[])elementsToMove, (Object)aClass) != -1) continue;
            all = false;
            break;
        }
        for (PsiClass aClass : classes) {
            allClasses.put(aClass, all);
        }
    }
}

