/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.MemberHidesStaticImportUsageInfo;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameJavaMemberProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.SubmemberHidesMemberUsageInfo;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameJavaMethodProcessor
extends RenameJavaMemberProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameJavaMethodProcessor");

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenameJavaMethodProcessor", "canProcessElement"));
        }
        return element instanceof PsiMethod;
    }

    @Override
    public void renameElement(PsiElement psiElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiAnnotation annotation;
        PsiElement element;
        PsiMethod method = (PsiMethod)psiElement;
        HashSet methodAndOverriders = new HashSet();
        HashSet containingClasses = new HashSet();
        LinkedHashSet<PsiElement> renamedReferences = new LinkedHashSet<PsiElement>();
        ArrayList<MemberHidesOuterMemberUsageInfo> outerHides = new ArrayList<MemberHidesOuterMemberUsageInfo>();
        ArrayList<MemberHidesStaticImportUsageInfo> staticImportHides = new ArrayList<MemberHidesStaticImportUsageInfo>();
        methodAndOverriders.add(method);
        containingClasses.add(method.getContainingClass());
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (element == null) continue;
            if (usage instanceof MemberHidesStaticImportUsageInfo) {
                staticImportHides.add((MemberHidesStaticImportUsageInfo)usage);
                continue;
            }
            if (usage instanceof MemberHidesOuterMemberUsageInfo) {
                PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)element;
                PsiMethod resolved = (PsiMethod)collidingRef.resolve();
                outerHides.add(new MemberHidesOuterMemberUsageInfo(element, (PsiMember)resolved));
                continue;
            }
            if (!(element instanceof PsiMethod)) {
                PsiElement e;
                PsiReference ref = usage instanceof MoveRenameUsageInfo ? usage.getReference() : element.getReference();
                if (ref instanceof PsiImportStaticReferenceElement && ((PsiImportStaticReferenceElement)ref).multiResolve(false).length > 1 || ref == null || (e = this.processRef(ref, newName)) == null) continue;
                renamedReferences.add(e);
                continue;
            }
            PsiMethod overrider = (PsiMethod)element;
            methodAndOverriders.add(overrider);
            containingClasses.add(overrider.getContainingClass());
        }
        method.setName(newName);
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (!(element instanceof PsiMethod)) continue;
            ((PsiMethod)element).setName(newName);
        }
        if (listener != null) {
            listener.elementRenamed((PsiElement)method);
        }
        for (PsiElement element2 : renamedReferences) {
            RenameJavaMethodProcessor.fixNameCollisionsWithInnerClassMethod(element2, newName, (Set<PsiMethod>)methodAndOverriders, (Set<PsiClass>)containingClasses, method.hasModifierProperty("static"));
        }
        RenameJavaMethodProcessor.qualifyOuterMemberReferences(outerHides);
        RenameJavaMethodProcessor.qualifyStaticImportReferences(staticImportHides);
        if (method.findDeepestSuperMethods().length == 0 && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"java.lang.Override"})) != null && annotation.isPhysical()) {
            annotation.delete();
        }
    }

    @Nullable
    protected PsiElement processRef(PsiReference ref, String newName) {
        return ref.handleElementRename(newName);
    }

    private static void fixNameCollisionsWithInnerClassMethod(PsiElement element, String newName, Set<PsiMethod> methodAndOverriders, Set<PsiClass> containingClasses, boolean isStatic) throws IncorrectOperationException {
        PsiMethod actualMethod;
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement elem = ((PsiReferenceExpression)element).resolve();
        if (elem instanceof PsiMethod && !methodAndOverriders.contains(actualMethod = (PsiMethod)elem)) {
            PsiClass outerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            while (outerClass != null) {
                if (containingClasses.contains(outerClass)) {
                    RenameJavaMethodProcessor.qualifyMember(element, newName, outerClass, isStatic);
                    break;
                }
                outerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)outerClass, PsiClass.class);
            }
        }
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
        Collection collection = MethodReferencesSearch.search((PsiMethod)((PsiMethod)element), (SearchScope)projectScope, (boolean)true).findAll();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenameJavaMethodProcessor", "findReferences"));
        }
        return collection;
    }

    @Override
    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result2) {
        PsiMethod methodToRename = (PsiMethod)element;
        RenameJavaMethodProcessor.findSubmemberHidesMemberCollisions(methodToRename, newName, result2);
        RenameJavaMethodProcessor.findMemberHidesOuterMemberCollisions((PsiMember)((PsiMethod)element), newName, result2);
        RenameJavaMethodProcessor.findCollisionsAgainstNewName((PsiMember)methodToRename, newName, result2);
        this.findHidingMethodWithOtherSignature(methodToRename, newName, result2);
        PsiClass containingClass = methodToRename.getContainingClass();
        if (containingClass != null) {
            PsiMethod patternMethod = (PsiMethod)methodToRename.copy();
            try {
                patternMethod.setName(newName);
                final PsiMethod methodInBaseClass = containingClass.findMethodBySignature(patternMethod, true);
                if (methodInBaseClass != null && methodInBaseClass.getContainingClass() != containingClass && methodInBaseClass.hasModifierProperty("final")) {
                    result2.add((UsageInfo)new UnresolvableCollisionUsageInfo((PsiElement)methodInBaseClass, (PsiElement)methodToRename){

                        @Override
                        public String getDescription() {
                            return "Renaming method will override final \"" + RefactoringUIUtil.getDescription((PsiElement)methodInBaseClass, true) + "\"";
                        }
                    });
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void findHidingMethodWithOtherSignature(PsiMethod methodToRename, String newName, List<UsageInfo> result2) {
        PsiClass containingClass = methodToRename.getContainingClass();
        if (containingClass != null) {
            PsiMethod prototype = RenameJavaMethodProcessor.getPrototypeWithNewName(methodToRename, newName);
            if (prototype == null || containingClass.findMethodBySignature(prototype, true) != null) {
                return;
            }
            PsiMethod[] methodsByName = containingClass.findMethodsByName(newName, true);
            if (methodsByName.length > 0) {
                for (UsageInfo info : result2) {
                    PsiReferenceExpression copyRef;
                    PsiElement element = info.getElement();
                    if (!(element instanceof PsiReferenceExpression) || ((PsiReferenceExpression)element).resolve() != methodToRename) continue;
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression copy = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText(parent.getText(), element);
                        copyRef = copy.getMethodExpression();
                    } else {
                        LOG.assertTrue(element instanceof PsiMethodReferenceExpression, (Object)element.getText());
                        copyRef = (PsiReferenceExpression)element.copy();
                    }
                    PsiReferenceExpression expression = (PsiReferenceExpression)this.processRef((PsiReference)copyRef, newName);
                    if (expression == null) continue;
                    JavaResolveResult resolveResult = expression.advancedResolve(true);
                    final PsiMember resolveResultElement = (PsiMember)resolveResult.getElement();
                    if (!resolveResult.isValidResult() || resolveResultElement == null) continue;
                    result2.add((UsageInfo)new UnresolvableCollisionUsageInfo(element, (PsiElement)methodToRename){

                        @Override
                        public String getDescription() {
                            return "Method call would be linked to \"" + RefactoringUIUtil.getDescription((PsiElement)resolveResultElement, true) + "\" after rename";
                        }
                    });
                    break;
                }
            }
        }
    }

    private static PsiMethod getPrototypeWithNewName(PsiMethod methodToRename, String newName) {
        PsiMethod prototype = (PsiMethod)methodToRename.copy();
        try {
            prototype.setName(newName);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
        return prototype;
    }

    @Override
    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        if (element instanceof PsiCompiledElement) {
            return;
        }
        PsiMethod refactoredMethod = (PsiMethod)element;
        if (newName.equals(refactoredMethod.getName())) {
            return;
        }
        PsiMethod prototype = RenameJavaMethodProcessor.getPrototypeWithNewName(refactoredMethod, newName);
        if (prototype == null) {
            return;
        }
        ConflictsUtil.checkMethodConflicts(refactoredMethod.getContainingClass(), refactoredMethod, prototype, conflicts);
    }

    @Override
    public void prepareRenaming(PsiElement element, final String newName, final Map<PsiElement, String> allRenames, SearchScope scope) {
        final PsiMethod method = (PsiMethod)element;
        OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).forEach((Processor)new Processor<PsiMethod>(){

            public boolean process(PsiMethod overrider) {
                String baseName;
                PsiElement prototype;
                if (overrider instanceof PsiMirrorElement && (prototype = ((PsiMirrorElement)overrider).getPrototype()) instanceof PsiMethod) {
                    overrider = (PsiMethod)prototype;
                }
                if (overrider instanceof SyntheticElement) {
                    return true;
                }
                String overriderName = overrider.getName();
                String newOverriderName = RefactoringUtil.suggestNewOverriderName(overriderName, baseName = method.getName(), newName);
                if (newOverriderName != null) {
                    RenameProcessor.assertNonCompileElement((PsiElement)overrider);
                    allRenames.put(overrider, newOverriderName);
                }
                return true;
            }
        });
    }

    @Override
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameMethod";
    }

    @Override
    public boolean isToSearchInComments(PsiElement psiElement) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = enabled;
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, Editor editor) {
        PsiMethod psiMethod = (PsiMethod)element;
        if (psiMethod.isConstructor()) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            if (Comparing.strEqual((String)psiMethod.getName(), (String)containingClass.getName())) {
                element = containingClass;
                if (!PsiElementRenameHandler.canRename(element.getProject(), editor, element)) {
                    return null;
                }
                return element;
            }
        }
        return SuperMethodWarningUtil.checkSuperMethod(psiMethod, RefactoringBundle.message((String)"to.rename"));
    }

    @Override
    public void substituteElementToRename(@NotNull PsiElement element, final @NotNull Editor editor, final @NotNull Pass<PsiElement> renameCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenameJavaMethodProcessor", "substituteElementToRename"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/rename/RenameJavaMethodProcessor", "substituteElementToRename"));
        }
        if (renameCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renameCallback", "com/intellij/refactoring/rename/RenameJavaMethodProcessor", "substituteElementToRename"));
        }
        PsiMethod psiMethod = (PsiMethod)element;
        if (psiMethod.isConstructor()) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!Comparing.strEqual((String)psiMethod.getName(), (String)containingClass.getName())) {
                renameCallback.pass((Object)psiMethod);
                return;
            }
            super.substituteElementToRename(element, editor, renameCallback);
        } else {
            SuperMethodWarningUtil.checkSuperMethod(psiMethod, "Rename", new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod method) {
                    if (method == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/rename/RenameJavaMethodProcessor$4", "execute"));
                    }
                    if (!PsiElementRenameHandler.canRename(method.getProject(), editor, (PsiElement)method)) {
                        return false;
                    }
                    renameCallback.pass((Object)method);
                    return false;
                }
            }, editor);
        }
    }

    private static void findSubmemberHidesMemberCollisions(PsiMethod method, String newName, List<UsageInfo> result2) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (method.hasModifierProperty("private")) {
            return;
        }
        Collection inheritors = ClassInheritorsSearch.search((PsiClass)containingClass, (boolean)true).findAll();
        MethodSignature oldSignature = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignature newSignature = MethodSignatureUtil.createMethodSignature((String)newName, (PsiType[])oldSignature.getParameterTypes(), (PsiTypeParameter[])oldSignature.getTypeParameters(), (PsiSubstitutor)oldSignature.getSubstitutor(), (boolean)method.isConstructor());
        block0: for (PsiClass inheritor : inheritors) {
            PsiMethod[] methodsByName;
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (PsiMethod conflictingMethod : methodsByName = inheritor.findMethodsByName(newName, false)) {
                if (!newSignature.equals(conflictingMethod.getSignature(superSubstitutor))) continue;
                result2.add((UsageInfo)new SubmemberHidesMemberUsageInfo((PsiElement)conflictingMethod, (PsiElement)method));
                continue block0;
            }
        }
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = enabled;
    }
}

