/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;

public class SafeDeleteExtendsClassUsageInfo
extends SafeDeleteReferenceUsageInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteExtendsClassUsageInfo");
    private final PsiClass myExtendingClass;
    private final PsiSubstitutor mySubstitutor;

    public SafeDeleteExtendsClassUsageInfo(PsiJavaCodeReferenceElement reference, PsiClass refClass, PsiClass extendingClass) {
        super((PsiElement)reference, (PsiElement)refClass, true);
        this.myExtendingClass = extendingClass;
        this.mySubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)refClass, (PsiClass)this.myExtendingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        LOG.assertTrue(this.mySubstitutor != null);
    }

    public PsiClass getReferencedElement() {
        return (PsiClass)super.getReferencedElement();
    }

    @Override
    public void deleteElement() throws IncorrectOperationException {
        PsiReferenceList implementsList;
        PsiElement parent = this.getElement().getParent();
        LOG.assertTrue(parent instanceof PsiReferenceList);
        PsiClass refClass = this.getReferencedElement();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)refClass.getProject()).getElementFactory();
        PsiReferenceList extendsList = refClass.getExtendsList();
        PsiReferenceList extendingImplementsList = this.myExtendingClass.getImplementsList();
        if (extendsList != null) {
            PsiClassType[] referenceTypes = extendsList.getReferencedTypes();
            PsiReferenceList listToAddExtends = refClass.isInterface() == this.myExtendingClass.isInterface() || this.myExtendingClass instanceof PsiTypeParameter ? this.myExtendingClass.getExtendsList() : extendingImplementsList;
            Object[] existingRefTypes = listToAddExtends.getReferencedTypes();
            for (PsiClassType referenceType : referenceTypes) {
                if (ArrayUtilRt.find((Object[])existingRefTypes, (Object)referenceType) > -1) continue;
                listToAddExtends.add((PsiElement)elementFactory.createReferenceElementByType((PsiClassType)this.mySubstitutor.substitute((PsiType)referenceType)));
            }
        }
        if ((implementsList = refClass.getImplementsList()) != null) {
            PsiClassType[] referenceTypes;
            Object[] existingRefTypes = extendingImplementsList.getReferencedTypes();
            for (PsiClassType referenceType : referenceTypes = implementsList.getReferencedTypes()) {
                if (ArrayUtilRt.find((Object[])existingRefTypes, (Object)referenceType) > -1) continue;
                extendingImplementsList.add((PsiElement)elementFactory.createReferenceElementByType((PsiClassType)this.mySubstitutor.substitute((PsiType)referenceType)));
            }
        }
        this.getElement().delete();
    }

    @Override
    public boolean isSafeDelete() {
        if (this.getElement() == null) {
            return false;
        }
        PsiClass refClass = this.getReferencedElement();
        if (refClass.getExtendsListTypes().length > 0) {
            PsiReferenceList listToAddExtends;
            PsiReferenceList psiReferenceList = listToAddExtends = refClass.isInterface() == this.myExtendingClass.isInterface() ? this.myExtendingClass.getExtendsList() : this.myExtendingClass.getImplementsList();
            if (listToAddExtends == null) {
                return false;
            }
        }
        return refClass.getImplementsListTypes().length <= 0 || this.myExtendingClass.getImplementsList() != null;
    }
}

