/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.ui.TypeListCreatingVisitor;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeSelectorManagerImpl
implements TypeSelectorManager {
    private SmartTypePointer myPointer;
    private PsiType myDefaultType;
    private final PsiExpression myMainOccurrence;
    private final PsiExpression[] myOccurrences;
    private final PsiType[] myTypesForMain;
    private final PsiType[] myTypesForAll;
    private final boolean myIsOneSuggestion;
    private final TypeSelector myTypeSelector;
    private final PsiElementFactory myFactory;
    private final SmartTypePointerManager mySmartTypePointerManager;
    private final ExpectedTypesProvider.ExpectedClassProvider myOccurrenceClassProvider;

    public TypeSelectorManagerImpl(Project project, PsiType type, PsiExpression[] occurrences) {
        this(project, type, occurrences, true);
    }

    public TypeSelectorManagerImpl(Project project, PsiType type, PsiExpression[] occurrences, boolean areTypesDirected) {
        this.myFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        this.mySmartTypePointerManager = SmartTypePointerManager.getInstance((Project)project);
        this.setDefaultType(type);
        this.myMainOccurrence = null;
        this.myOccurrences = occurrences;
        this.myOccurrenceClassProvider = this.createOccurrenceClassProvider();
        this.myTypesForAll = this.getTypesForAll(areTypesDirected);
        this.myTypesForMain = PsiType.EMPTY_ARRAY;
        boolean bl = this.myIsOneSuggestion = this.myTypesForAll.length == 1;
        if (this.myIsOneSuggestion) {
            this.myTypeSelector = new TypeSelector(this.myTypesForAll[0], project);
        } else {
            this.myTypeSelector = new TypeSelector(project);
            this.setTypesAndPreselect(this.myTypesForAll);
        }
    }

    public TypeSelectorManagerImpl(Project project, PsiType type, PsiExpression mainOccurrence, PsiExpression[] occurrences) {
        this(project, type, null, mainOccurrence, occurrences);
    }

    public TypeSelectorManagerImpl(Project project, PsiType type, PsiMethod containingMethod, PsiExpression mainOccurrence, PsiExpression[] occurrences) {
        this.myFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        this.mySmartTypePointerManager = SmartTypePointerManager.getInstance((Project)project);
        this.setDefaultType(type);
        this.myMainOccurrence = mainOccurrence;
        this.myOccurrences = occurrences;
        this.myOccurrenceClassProvider = this.createOccurrenceClassProvider();
        this.myTypesForMain = this.getTypesForMain();
        this.myTypesForAll = this.getTypesForAll(true);
        if (containingMethod != null && PsiUtil.resolveClassInType((PsiType)type) != null) {
            this.setDefaultType(this.checkIfTypeAccessible(type, project, containingMethod));
        }
        this.myIsOneSuggestion = this.myTypesForMain.length == 1 && this.myTypesForAll.length == 1 && this.myTypesForAll[0].equals(this.myTypesForMain[0]);
        this.myTypeSelector = this.myIsOneSuggestion ? new TypeSelector(this.myTypesForAll[0], project) : new TypeSelector(project);
    }

    private PsiType checkIfTypeAccessible(PsiType type, Project project, PsiMethod containingMethod) {
        PsiClass parentClass = containingMethod.getContainingClass();
        PsiClass typeClass = PsiUtil.resolveClassInType((PsiType)type);
        if (typeClass != null) {
            int nextTypeIdx;
            if (typeClass instanceof PsiTypeParameter) {
                if (ArrayUtil.find((Object[])parentClass.getTypeParameters(), (Object)typeClass) == -1) {
                    return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                }
            } else if (PsiTreeUtil.isAncestor((PsiElement)containingMethod, (PsiElement)typeClass, (boolean)true) && (nextTypeIdx = ArrayUtil.find((Object[])this.myTypesForAll, (Object)type) + 1) < this.myTypesForAll.length) {
                return this.checkIfTypeAccessible(this.myTypesForAll[nextTypeIdx], project, containingMethod);
            }
        }
        return type;
    }

    public PsiType[] getTypesForAll() {
        return this.myTypesForAll;
    }

    public PsiType[] getTypesForOne() {
        return this.myTypesForMain;
    }

    public PsiType getDefaultType() {
        if (this.myDefaultType.isValid()) {
            return this.myDefaultType;
        }
        return this.myPointer.getType();
    }

    public void setDefaultType(PsiType defaultType) {
        this.myDefaultType = defaultType;
        this.myPointer = this.mySmartTypePointerManager.createSmartTypePointer(defaultType);
    }

    private ExpectedTypesProvider.ExpectedClassProvider createOccurrenceClassProvider() {
        HashSet<PsiClass> occurrenceClasses = new HashSet<PsiClass>();
        for (PsiExpression occurrence : this.myOccurrences) {
            PsiType occurrenceType = occurrence.getType();
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)occurrenceType);
            if (aClass == null) continue;
            occurrenceClasses.add(aClass);
        }
        return new ExpectedTypeUtil.ExpectedClassesFromSetProvider(occurrenceClasses);
    }

    private PsiType[] getTypesForMain() {
        final ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes(this.myMainOccurrence, false, this.myOccurrenceClassProvider, false);
        final ArrayList<PsiType> allowedTypes = new ArrayList<PsiType>();
        RefactoringHierarchyUtil.processSuperTypes(this.getDefaultType(), new RefactoringHierarchyUtil.SuperTypeVisitor(){

            @Override
            public void visitType(PsiType aType) {
                this.checkIfAllowed(aType);
            }

            @Override
            public void visitClass(PsiClass aClass) {
                this.checkIfAllowed((PsiType)TypeSelectorManagerImpl.this.myFactory.createType(aClass));
            }

            private void checkIfAllowed(PsiType type) {
                if (expectedTypes.length > 0) {
                    ExpectedTypeInfo typeInfo = ExpectedTypesProvider.createInfo(type, 0, type, TailType.NONE);
                    for (ExpectedTypeInfo expectedType : expectedTypes) {
                        if (expectedType.intersect(typeInfo).length == 0) continue;
                        allowedTypes.add(type);
                        break;
                    }
                } else {
                    allowedTypes.add(type);
                }
            }
        });
        TypeSelectorManagerImpl.collectAllSameShapedTypes(expectedTypes, allowedTypes);
        ArrayList<PsiType> result2 = this.normalizeTypeList(allowedTypes);
        return result2.toArray(PsiType.createArray((int)result2.size()));
    }

    private static void collectAllSameShapedTypes(ExpectedTypeInfo[] expectedTypes, ArrayList<PsiType> allowedTypes) {
        for (ExpectedTypeInfo info : expectedTypes) {
            if (info.getKind() != 4) continue;
            allowedTypes.add(info.getDefaultType());
        }
    }

    protected PsiType[] getTypesForAll(boolean areTypesDirected) {
        final ArrayList<ExpectedTypeInfo[]> expectedTypesFromAll = new ArrayList<ExpectedTypeInfo[]>();
        for (PsiExpression occurrence : this.myOccurrences) {
            ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes(occurrence, false, this.myOccurrenceClassProvider, this.isUsedAfter());
            if (expectedTypes.length <= 0) continue;
            expectedTypesFromAll.add(expectedTypes);
        }
        final ArrayList<PsiType> allowedTypes = new ArrayList<PsiType>();
        RefactoringHierarchyUtil.processSuperTypes(this.getDefaultType(), new RefactoringHierarchyUtil.SuperTypeVisitor(){

            @Override
            public void visitType(PsiType aType) {
                this.checkIfAllowed(aType);
            }

            @Override
            public void visitClass(PsiClass aClass) {
                this.checkIfAllowed((PsiType)TypeSelectorManagerImpl.this.myFactory.createType(aClass));
            }

            private void checkIfAllowed(PsiType type) {
                Iterator iterator = expectedTypesFromAll.iterator();
                block0: while (iterator.hasNext()) {
                    ExpectedTypeInfo[] expectedTypes;
                    for (ExpectedTypeInfo info : expectedTypes = (ExpectedTypeInfo[])iterator.next()) {
                        if (ExpectedTypeUtil.matches(type, info)) continue block0;
                    }
                    return;
                }
                allowedTypes.add(type);
            }
        });
        for (ExpectedTypeInfo[] typeInfos : expectedTypesFromAll) {
            TypeSelectorManagerImpl.collectAllSameShapedTypes(typeInfos, allowedTypes);
        }
        ArrayList<PsiType> result2 = this.normalizeTypeList(allowedTypes);
        if (!areTypesDirected) {
            Collections.reverse(result2);
        }
        return result2.toArray(PsiType.createArray((int)result2.size()));
    }

    protected boolean isUsedAfter() {
        return false;
    }

    private ArrayList<PsiType> normalizeTypeList(ArrayList<PsiType> typeList) {
        PsiClassType boxedType;
        PsiPrimitiveType unboxedType;
        ArrayList<PsiType> result2 = new ArrayList<PsiType>();
        TypeListCreatingVisitor visitor = new TypeListCreatingVisitor(result2, this.myFactory);
        for (PsiType psiType : typeList) {
            visitor.visitType(psiType);
        }
        PsiType defaultType = this.getDefaultType();
        for (int index = 0; index < result2.size(); ++index) {
            PsiType psiType = result2.get(index);
            if (!psiType.equals(defaultType)) continue;
            result2.remove(index);
            break;
        }
        if ((unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)defaultType)) != null) {
            result2.remove(unboxedType);
            result2.add(0, (PsiType)unboxedType);
        }
        if (defaultType instanceof PsiPrimitiveType && this.myMainOccurrence != null && (boxedType = ((PsiPrimitiveType)defaultType).getBoxedType((PsiElement)this.myMainOccurrence)) != null) {
            result2.remove(boxedType);
            result2.add(0, (PsiType)boxedType);
        }
        if (!TypeConversionUtil.isComposite((PsiType)defaultType)) {
            result2.add(0, defaultType);
        }
        return result2;
    }

    @Override
    public void setAllOccurrences(boolean allOccurrences) {
        if (this.myIsOneSuggestion) {
            return;
        }
        this.setTypesAndPreselect(allOccurrences ? this.myTypesForAll : this.myTypesForMain);
    }

    private void setTypesAndPreselect(PsiType[] types) {
        this.myTypeSelector.setTypes(types);
        THashMap map = new THashMap();
        for (PsiType psiType : types) {
            map.put(TypeSelectorManagerImpl.serialize(psiType), psiType);
        }
        for (PsiType psiType : StatisticsManager.getInstance().getAllValues(this.getStatsKey())) {
            PsiType candidate = (PsiType)map.get(psiType.getValue());
            if (candidate == null || StatisticsManager.getInstance().getUseCount((StatisticsInfo)psiType) <= 0) continue;
            this.myTypeSelector.selectType(candidate);
            return;
        }
    }

    @Override
    public boolean isSuggestedType(String fqName) {
        for (PsiType type : this.myTypesForAll) {
            if (!type.getCanonicalText().equals(fqName)) continue;
            return true;
        }
        for (PsiType type : this.myTypesForMain) {
            if (!type.getCanonicalText().equals(fqName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void typeSelected(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/ui/TypeSelectorManagerImpl", "typeSelected"));
        }
        TypeSelectorManagerImpl.typeSelected(type, this.getDefaultType());
    }

    public static void typeSelected(@NotNull PsiType type, @Nullable PsiType defaultType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/ui/TypeSelectorManagerImpl", "typeSelected"));
        }
        if (defaultType == null) {
            return;
        }
        StatisticsManager.getInstance().incUseCount(new StatisticsInfo(TypeSelectorManagerImpl.getStatsKey(defaultType), TypeSelectorManagerImpl.serialize(type)));
    }

    private String getStatsKey() {
        PsiType defaultType = this.getDefaultType();
        if (defaultType == null) {
            return "IntroduceVariable##";
        }
        return TypeSelectorManagerImpl.getStatsKey(defaultType);
    }

    private static String getStatsKey(PsiType defaultType) {
        return "IntroduceVariable##" + TypeSelectorManagerImpl.serialize(defaultType);
    }

    private static String serialize(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/ui/TypeSelectorManagerImpl", "serialize"));
        }
        if (PsiUtil.resolveClassInType((PsiType)type) instanceof PsiTypeParameter) {
            return type.getCanonicalText();
        }
        return TypeConversionUtil.erasure((PsiType)type).getCanonicalText();
    }

    @Override
    public TypeSelector getTypeSelector() {
        return this.myTypeSelector;
    }
}

