/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import org.jetbrains.annotations.NotNull;

public class JavaRefactoringElementDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/JavaRefactoringElementDescriptionProvider", "getElementDescription"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/refactoring/util/JavaRefactoringElementDescriptionProvider", "getElementDescription"));
        }
        if (!(location instanceof RefactoringDescriptionLocation)) {
            return null;
        }
        RefactoringDescriptionLocation rdLocation = (RefactoringDescriptionLocation)location;
        if (element instanceof PsiField) {
            int options = 1;
            if (rdLocation.includeParent()) {
                options |= 0x1000;
            }
            return RefactoringBundle.message((String)"field.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY))});
        }
        if (element instanceof PsiMethod) {
            PsiMethod method;
            int options = 257;
            if (rdLocation.includeParent()) {
                options |= 0x1000;
            }
            return (method = (PsiMethod)element).isConstructor() ? RefactoringBundle.message((String)"constructor.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2))}) : RefactoringBundle.message((String)"method.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2))});
        }
        if (element instanceof PsiClassInitializer) {
            PsiClassInitializer initializer = (PsiClassInitializer)element;
            boolean isStatic = initializer.hasModifierProperty("static");
            return isStatic ? RefactoringBundle.message((String)"static.initializer.description", (Object[])new Object[]{this.getElementDescription((PsiElement)initializer.getContainingClass(), RefactoringDescriptionLocation.WITHOUT_PARENT)}) : RefactoringBundle.message((String)"instance.initializer.description", (Object[])new Object[]{this.getElementDescription((PsiElement)initializer.getContainingClass(), RefactoringDescriptionLocation.WITHOUT_PARENT)});
        }
        if (element instanceof PsiParameter) {
            if (((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement) {
                return RefactoringBundle.message((String)"local.variable.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiVariable)element).getName())});
            }
            return RefactoringBundle.message((String)"parameter.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiParameter)element).getName())});
        }
        if (element instanceof PsiLocalVariable) {
            return RefactoringBundle.message((String)"local.variable.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiVariable)element).getName())});
        }
        if (element instanceof PsiPackage) {
            return RefactoringBundle.message((String)"package.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiPackage)element).getName())});
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            return RefactoringBundle.message((String)"class.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)DescriptiveNameUtil.getDescriptiveName((PsiElement)psiClass))});
        }
        return null;
    }
}

