/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.TestFinderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GotoTestRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/testIntegration/GotoTestRelatedProvider", "getItems"));
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestRelatedProvider", "getItems"));
            }
            return list;
        }
        boolean isTest = TestFinderHelper.isTest((PsiElement)file);
        Collection<PsiElement> result2 = isTest ? TestFinderHelper.findClassesForTest((PsiElement)file) : TestFinderHelper.findTestsForClass((PsiElement)file);
        if (!result2.isEmpty()) {
            ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>();
            for (PsiElement element : result2) {
                items.add(new GotoRelatedItem(element, isTest ? "Tests" : "Testee classes"));
            }
            ArrayList<GotoRelatedItem> arrayList = items;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestRelatedProvider", "getItems"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestRelatedProvider", "getItems"));
        }
        return list;
    }
}

