/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.WindowMouseListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class WindowResizeListener
extends WindowMouseListener {
    private final Insets myBorder;
    private final Icon myCorner;

    public WindowResizeListener(Component content, Insets border, Icon corner) {
        super(content);
        this.myBorder = border;
        this.myCorner = corner;
    }

    @Override
    int getCursorType(Component view, Point location) {
        int top;
        Container parent;
        Container container = parent = view instanceof Window ? null : view.getParent();
        if (parent != null) {
            SwingUtilities.convertPointFromScreen(location, parent);
        }
        if ((top = location.y - view.getY()) < 0) {
            return -1;
        }
        int left = location.x - view.getX();
        if (left < 0) {
            return -1;
        }
        int right = view.getWidth() - left;
        if (right < 0) {
            return -1;
        }
        int bottom = view.getHeight() - top;
        if (bottom < 0) {
            return -1;
        }
        if (this.myCorner != null && right < this.myCorner.getIconWidth() && bottom < this.myCorner.getIconHeight()) {
            return 0;
        }
        if (this.myBorder != null) {
            if (top < this.myBorder.top) {
                if (left < this.myBorder.left) {
                    return 6;
                }
                if (right < this.myBorder.right) {
                    return 7;
                }
                return 8;
            }
            if (bottom < this.myBorder.bottom) {
                if (left < this.myBorder.left) {
                    return 4;
                }
                if (right < this.myBorder.right) {
                    return 5;
                }
                return 9;
            }
            if (left < this.myBorder.left) {
                return 10;
            }
            if (right < this.myBorder.right) {
                return 11;
            }
        }
        return -1;
    }

    @Override
    void updateBounds(Rectangle bounds, Component view, int dx, int dy) {
        Dimension minimum = view.getMinimumSize();
        if (this.myType == 7 || this.myType == 11 || this.myType == 5 || this.myType == 0) {
            bounds.width += WindowResizeListener.fixMinSize(dx, bounds.width, minimum.width);
        } else if (this.myType == 6 || this.myType == 10 || this.myType == 4) {
            dx = WindowResizeListener.fixMinSize(-dx, bounds.width, minimum.width);
            bounds.x -= dx;
            bounds.width += dx;
        }
        if (this.myType == 4 || this.myType == 9 || this.myType == 5 || this.myType == 0) {
            bounds.height += WindowResizeListener.fixMinSize(dy, bounds.height, minimum.height);
        } else if (this.myType == 6 || this.myType == 8 || this.myType == 7) {
            dy = WindowResizeListener.fixMinSize(-dy, bounds.height, minimum.height);
            bounds.y -= dy;
            bounds.height += dy;
        }
    }

    private static int fixMinSize(int delta, int value, int min) {
        return delta + value < min ? min - value : delta;
    }
}

