/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.GeneralRunner;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;

public class SameProgressRunner
extends GeneralRunner {
    private final Thread myInitThread;
    private final Semaphore mySemaphore;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.continuation.SameProgressRunner");

    public SameProgressRunner(Project project, boolean cancellable) {
        super(project, cancellable);
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) assert (!application.isDispatchThread());
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        this.setIndicator(indicator);
        this.myInitThread = Thread.currentThread();
        this.mySemaphore = new Semaphore();
    }

    @Override
    public void ping() {
        this.clearSuspend();
        if (Thread.currentThread().equals(this.myInitThread)) {
            new Runnable(){

                @Override
                public void run() {
                    SameProgressRunner.this.pingInSourceThread();
                }
            }.run();
        } else {
            this.mySemaphore.up();
        }
    }

    private void pingInSourceThread() {
        while (true) {
            try {
                while (true) {
                    TaskDescriptor current;
                    if (ApplicationManager.getApplication().isDisposed() || !this.myProject.isOpen()) {
                        return;
                    }
                    if (this.getSuspendFlag()) {
                        this.mySemaphore.down();
                        while (this.getSuspendFlag()) {
                            this.mySemaphore.waitFor(500L);
                        }
                    }
                    if ((current = this.getNextMatching()) == null) {
                        return;
                    }
                    if (Where.AWT.equals((Object)current.getWhere())) {
                        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                current.run((ContinuationContext)SameProgressRunner.this);
                            }
                        });
                        continue;
                    }
                    current.run((ContinuationContext)this);
                }
            }
            catch (ProcessCanceledException current) {
                continue;
            }
            catch (Throwable t) {
                LOG.error(t);
                this.cancelIndicator();
                continue;
            }
            break;
        }
    }
}

