/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.download.impl.DownloadableFileDescriptionImpl;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import com.intellij.util.download.impl.FileDownloaderImpl;
import com.intellij.util.download.impl.FileSetVersionsFetcherBase;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadableFileServiceImpl
extends DownloadableFileService {
    @NotNull
    public DownloadableFileDescription createFileDescription(@NotNull String downloadUrl, @NotNull String fileName) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadUrl", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createFileDescription"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createFileDescription"));
        }
        DownloadableFileDescriptionImpl downloadableFileDescriptionImpl = new DownloadableFileDescriptionImpl(downloadUrl, FileUtil.getNameWithoutExtension((String)fileName), FileUtilRt.getExtension((String)fileName));
        if (downloadableFileDescriptionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createFileDescription"));
        }
        return downloadableFileDescriptionImpl;
    }

    @NotNull
    public DownloadableFileSetVersions<DownloadableFileSetDescription> createFileSetVersions(@Nullable String groupId, URL ... localUrls) {
        if (localUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localUrls", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createFileSetVersions"));
        }
        FileSetVersionsFetcherBase<DownloadableFileSetDescription, DownloadableFileDescription> fileSetVersionsFetcherBase = new FileSetVersionsFetcherBase<DownloadableFileSetDescription, DownloadableFileDescription>(groupId, localUrls){

            @Override
            protected DownloadableFileSetDescription createVersion(Artifact version, List<DownloadableFileDescription> files) {
                return new DownloadableFileSetDescriptionImpl<DownloadableFileDescription>(version.getName(), version.getVersion(), files);
            }

            @Override
            protected DownloadableFileDescription createFileDescription(ArtifactItem item, String url, String prefix) {
                return DownloadableFileService.getInstance().createFileDescription(url, item.getName());
            }
        };
        if (fileSetVersionsFetcherBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createFileSetVersions"));
        }
        return fileSetVersionsFetcherBase;
    }

    @NotNull
    public FileDownloader createDownloader(@NotNull DownloadableFileSetDescription description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        FileDownloader fileDownloader = this.createDownloader(description.getFiles(), description.getName());
        if (fileDownloader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        return fileDownloader;
    }

    @NotNull
    public FileDownloader createDownloader(@NotNull List<? extends DownloadableFileDescription> fileDescriptions, @NotNull String presentableDownloadName) {
        if (fileDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDescriptions", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        if (presentableDownloadName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableDownloadName", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        FileDownloaderImpl fileDownloaderImpl = new FileDownloaderImpl(fileDescriptions, null, null, presentableDownloadName);
        if (fileDownloaderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        return fileDownloaderImpl;
    }

    @NotNull
    public FileDownloader createDownloader(@NotNull DownloadableFileSetDescription description, @Nullable Project project, JComponent parent) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        FileDownloader fileDownloader = this.createDownloader(description.getFiles(), project, parent, description.getName());
        if (fileDownloader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        return fileDownloader;
    }

    @NotNull
    public FileDownloader createDownloader(List<? extends DownloadableFileDescription> fileDescriptions, @Nullable Project project, JComponent parent, @NotNull String presentableDownloadName) {
        if (presentableDownloadName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableDownloadName", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        FileDownloaderImpl fileDownloaderImpl = new FileDownloaderImpl(fileDescriptions, project, parent, presentableDownloadName);
        if (fileDownloaderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileServiceImpl", "createDownloader"));
        }
        return fileDownloaderImpl;
    }
}

