/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedChildDescriptionImpl
extends DomChildDescriptionImpl
implements DomFixedChildDescription {
    private final Collection<JavaMethod>[] myGetterMethods;
    private final int myCount;

    public FixedChildDescriptionImpl(XmlName tagName, Type type, int count, Collection<JavaMethod>[] getterMethods) {
        super(tagName, type);
        assert (getterMethods.length == count || getterMethods == ArrayUtil.EMPTY_COLLECTION_ARRAY);
        this.myCount = count;
        this.myGetterMethods = getterMethods;
    }

    public JavaMethod getGetterMethod(int index) {
        if (this.myGetterMethods.length == 0) {
            return null;
        }
        Collection<JavaMethod> methods = this.myGetterMethods[index];
        return methods == null || methods.isEmpty() ? null : methods.iterator().next();
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(int index, Class<? extends T> annotationClass) {
        T annotation;
        Annotation annotation2;
        JavaMethod method = this.getGetterMethod(index);
        if (method != null && (annotation2 = method.getAnnotation(annotationClass)) != null) {
            return (T)annotation2;
        }
        Type elemType = this.getType();
        if (elemType instanceof AnnotatedElement && (annotation = ((AnnotatedElement)((Object)elemType)).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        return super.getAnnotation(annotationClass);
    }

    public int getCount() {
        return this.myCount;
    }

    @NotNull
    public List<? extends DomElement> getValues(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/impl/FixedChildDescriptionImpl", "getValues"));
        }
        SmartList result2 = new SmartList();
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element);
        if (handler2 != null) {
            for (int i = 0; i < this.myCount; ++i) {
                result2.add(handler2.getFixedChild((Pair<FixedChildDescriptionImpl, Integer>)Pair.create((Object)this, (Object)i)).getProxy());
            }
        } else {
            for (Collection<JavaMethod> methods : this.myGetterMethods) {
                if (methods == null || methods.isEmpty()) continue;
                result2.add((DomElement)methods.iterator().next().invoke((Object)element, ArrayUtil.EMPTY_OBJECT_ARRAY));
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/FixedChildDescriptionImpl", "getValues"));
        }
        return smartList;
    }

    @NotNull
    public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/xml/impl/FixedChildDescriptionImpl", "getCommonPresentableName"));
        }
        String string = StringUtil.capitalizeWords((String)strategy.splitIntoWords(this.getXmlElementName()), (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/FixedChildDescriptionImpl", "getCommonPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(0, annotationClass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FixedChildDescriptionImpl that = (FixedChildDescriptionImpl)o;
        if (this.myCount != that.myCount) {
            return false;
        }
        return Arrays.equals(this.myGetterMethods, that.myGetterMethods);
    }

    public String toString() {
        return this.getXmlElementName() + " " + this.getGetterMethod(0) + " " + this.getType();
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 29 * result2 + this.myCount;
        return result2;
    }
}

