/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageVersionComparator
implements Comparator<String> {
    public static final Comparator<String> VERSION_COMPARATOR = new PackageVersionComparator();

    @Override
    public int compare(String version1, String version2) {
        List<String> vs1 = this.parse(version1);
        List<String> vs2 = this.parse(version2);
        int result2 = 0;
        for (int i = 0; i < vs1.size() && i < vs2.size() && (result2 = vs1.get(i).compareTo(vs2.get(i))) == 0; ++i) {
        }
        if (result2 == 0) {
            return vs1.size() - vs2.size();
        }
        return result2;
    }

    @Nullable
    private static String replace(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/webcore/packaging/PackageVersionComparator", "replace"));
        }
        ImmutableMap sub = ImmutableMap.of((Object)"pre", (Object)"c", (Object)"preview", (Object)"c", (Object)"rc", (Object)"c", (Object)"dev", (Object)"@");
        String tmp = (String)sub.get(s);
        if (tmp != null) {
            s = tmp;
        }
        if (s.equals(".") || s.equals("-")) {
            return null;
        }
        if (s.matches("[0-9]+")) {
            try {
                long value = Long.parseLong(s);
                return String.format("%08d", value);
            }
            catch (NumberFormatException e) {
                return s;
            }
        }
        return "*" + s;
    }

    @NotNull
    private List<String> parse(@Nullable String s) {
        if (s == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/PackageVersionComparator", "parse"));
            }
            return list;
        }
        Pattern COMPONENT_RE = Pattern.compile("\\d+|[a-z]+|\\.|-|.+");
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = COMPONENT_RE.matcher(s);
        while (matcher.find()) {
            String component = PackageVersionComparator.replace(matcher.group());
            if (component == null) continue;
            results.add(component);
        }
        for (int i = results.size() - 1; i > 0 && "00000000".equals(results.get(i)); --i) {
            results.remove(i);
        }
        results.add("*final");
        ArrayList<String> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/PackageVersionComparator", "parse"));
        }
        return arrayList;
    }
}

