/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDeprecatedAnnotationInspection
extends BaseInspection {
    public boolean warnOnMissingJavadoc = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean annotationWarning = (Boolean)infos[0];
        String string = annotationWarning ? InspectionGadgetsBundle.message("missing.deprecated.annotation.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("missing.deprecated.tag.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("missing.deprecated.tag.option", new Object[0]), (InspectionProfileEntry)this, "warnOnMissingJavadoc");
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean annotationWarning = (Boolean)infos[0];
        if (!annotationWarning) {
            return null;
        }
        return new MissingDeprecatedAnnotationFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingDeprecatedAnnotationVisitor();
    }

    private class MissingDeprecatedAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingDeprecatedAnnotationVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor", "visitClass"));
            }
            super.visitClass(aClass);
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)aClass)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiDocCommentOwner)aClass, true)) {
                    this.registerClassError(aClass, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiDocCommentOwner)aClass, false)) {
                this.registerClassError(aClass, Boolean.TRUE);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor", "visitMethod"));
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)method)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiDocCommentOwner)method, true)) {
                    this.registerMethodError(method, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiDocCommentOwner)method, false)) {
                this.registerMethodError(method, Boolean.TRUE);
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor", "visitField"));
            }
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)field)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiDocCommentOwner)field, true)) {
                    this.registerFieldError(field, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiDocCommentOwner)field, false)) {
                this.registerFieldError(field, Boolean.TRUE);
            }
        }

        private boolean hasDeprecatedAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            return modifierList != null && modifierList.findAnnotation("java.lang.Deprecated") != null;
        }

        private boolean hasDeprecatedComment(PsiDocCommentOwner element, boolean checkContent) {
            PsiDocComment comment = element.getDocComment();
            if (comment == null) {
                return false;
            }
            PsiDocTag deprecatedTag = comment.findTagByName("deprecated");
            if (deprecatedTag == null) {
                return false;
            }
            return !checkContent || deprecatedTag.getValueElement() != null;
        }
    }

    private static class MissingDeprecatedAnnotationFix
    extends InspectionGadgetsFix {
        private MissingDeprecatedAnnotationFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement identifier = descriptor.getPsiElement();
            PsiModifierListOwner parent = (PsiModifierListOwner)identifier.getParent();
            if (parent == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation annotation = factory.createAnnotationFromText("@java.lang.Deprecated", (PsiElement)parent);
            PsiModifierList modifierList = parent.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter((PsiElement)annotation, null);
        }
    }
}

