/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UseOfProcessBuilderInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.processbuilder.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/UseOfProcessBuilderInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.processbuilder.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/UseOfProcessBuilderInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProcessBuilderVisitor();
    }

    private static class ProcessBuilderVisitor
    extends BaseInspectionVisitor {
        private ProcessBuilderVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/portability/UseOfProcessBuilderInspection$ProcessBuilderVisitor", "visitVariable"));
            }
            super.visitVariable(variable);
            PsiType type = variable.getType();
            String typeString = type.getCanonicalText();
            if (!"java.lang.ProcessBuilder".equals(typeString)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            if (newExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/portability/UseOfProcessBuilderInspection$ProcessBuilderVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(newExpression);
            PsiType type = newExpression.getType();
            if (type == null) {
                return;
            }
            String typeString = type.getCanonicalText();
            if (!"java.lang.ProcessBuilder".equals(typeString)) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }
    }
}

