/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class RemoveConditionalPredicate
implements PsiElementPredicate {
    RemoveConditionalPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiConditionalExpression)) {
            return false;
        }
        PsiConditionalExpression condition = (PsiConditionalExpression)element;
        PsiExpression thenExpression = condition.getThenExpression();
        PsiExpression elseExpression = condition.getElseExpression();
        if (thenExpression == null || elseExpression == null) {
            return false;
        }
        thenExpression = ParenthesesUtils.stripParentheses(thenExpression);
        elseExpression = ParenthesesUtils.stripParentheses(elseExpression);
        if (thenExpression == null || elseExpression == null) {
            return false;
        }
        String thenText = thenExpression.getText();
        String elseText = elseExpression.getText();
        if ("true".equals(elseText) && "false".equals(thenText)) {
            return !ErrorUtil.containsError(element);
        }
        if ("true".equals(thenText) && "false".equals(elseText)) {
            return !ErrorUtil.containsError(element);
        }
        return false;
    }
}

