/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.TryWithMultipleResourcesPredicate;
import org.jetbrains.annotations.NotNull;

public class SplitTryWithMultipleResourcesIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        TryWithMultipleResourcesPredicate tryWithMultipleResourcesPredicate = new TryWithMultipleResourcesPredicate();
        if (tryWithMultipleResourcesPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/exceptions/SplitTryWithMultipleResourcesIntention", "getElementPredicate"));
        }
        return tryWithMultipleResourcesPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiCatchSection[] catchSections;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/exceptions/SplitTryWithMultipleResourcesIntention", "processIntention"));
        }
        PsiTryStatement tryStatement = (PsiTryStatement)element.getParent();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return;
        }
        StringBuilder newTryStatementText = new StringBuilder();
        int count = 0;
        for (PsiResourceListElement resource : resourceList) {
            if (count > 0) {
                newTryStatementText.append("{\n");
            }
            ++count;
            newTryStatementText.append("try (").append(resource.getText()).append(")");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        newTryStatementText.append(tryBlock.getText());
        for (int i = 1; i < count; ++i) {
            newTryStatementText.append("\n}");
        }
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            newTryStatementText.append(catchSection.getText());
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatementText.append("finally").append(finallyBlock.getText());
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)tryStatement, newTryStatementText.toString());
    }
}

