/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConvertJUnit3TestCaseToJUnit4Predicate
implements PsiElementPredicate {
    ConvertJUnit3TestCaseToJUnit4Predicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)parent;
        PsiElement leftBrace = aClass.getLBrace();
        int offsetInParent = element.getStartOffsetInParent();
        if (leftBrace == null || offsetInParent >= leftBrace.getStartOffsetInParent()) {
            return false;
        }
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList == null) {
            return false;
        }
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        if (referenceElements.length != 1) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = referenceElements[0];
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiClass)) {
            return false;
        }
        PsiClass targetClass = (PsiClass)target;
        String name = targetClass.getQualifiedName();
        if (!"junit.framework.TestCase".equals(name)) {
            return false;
        }
        Project project = element.getProject();
        GlobalSearchScope scope = element.getResolveScope();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass testAnnotation = psiFacade.findClass("org.junit.Test", scope);
        return testAnnotation != null;
    }
}

