/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;

final class ImageEditorImpl
implements ImageEditor {
    private final Project project;
    private final VirtualFile file;
    private final ImageEditorUI editorUI;
    private boolean disposed;

    ImageEditorImpl(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/impl/ImageEditorImpl", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/editor/impl/ImageEditorImpl", "<init>"));
        }
        this.project = project;
        this.file = file;
        this.editorUI = new ImageEditorUI(this);
        Disposer.register((Disposable)this, (Disposable)this.editorUI);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/editor/impl/ImageEditorImpl$1", "propertyChanged"));
                }
                ImageEditorImpl.this.propertyChanged(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/editor/impl/ImageEditorImpl$1", "contentsChanged"));
                }
                ImageEditorImpl.this.contentsChanged(event);
            }
        }, (Disposable)this);
        this.setValue(file);
    }

    private void setValue(VirtualFile file) {
        try {
            this.editorUI.setImage(IfsUtil.getImage(file), IfsUtil.getFormat(file));
        }
        catch (Exception e) {
            this.editorUI.setImage(null, null);
        }
    }

    @Override
    public boolean isValid() {
        ImageDocument document = this.editorUI.getImageComponent().getDocument();
        return document.getValue() != null;
    }

    @Override
    public JComponent getComponent() {
        return this.editorUI;
    }

    @Override
    public JComponent getContentComponent() {
        return this.editorUI.getImageComponent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageEditorImpl", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageEditorImpl", "getProject"));
        }
        return project;
    }

    @Override
    public ImageDocument getDocument() {
        return this.editorUI.getImageComponent().getDocument();
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        this.editorUI.getImageComponent().setTransparencyChessboardVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.editorUI.getImageComponent().isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return !"Images.Thumbnails".equals(place);
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.editorUI.getImageComponent().setGridVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public boolean isGridVisible() {
        return this.editorUI.getImageComponent().isGridVisible();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return this.editorUI.getZoomModel();
    }

    public void dispose() {
        this.disposed = true;
    }

    void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/editor/impl/ImageEditorImpl", "propertyChanged"));
        }
        if (this.file.equals(event.getFile())) {
            this.file.refresh(true, false, new Runnable(){

                @Override
                public void run() {
                    if (ImageFileTypeManager.getInstance().isImage(ImageEditorImpl.this.file)) {
                        ImageEditorImpl.this.setValue(ImageEditorImpl.this.file);
                    } else {
                        ImageEditorImpl.this.setValue(null);
                        FileEditorManager editorManager = FileEditorManager.getInstance((Project)ImageEditorImpl.this.project);
                        editorManager.closeFile(ImageEditorImpl.this.file);
                    }
                }
            });
        }
    }

    void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/editor/impl/ImageEditorImpl", "contentsChanged"));
        }
        if (this.file.equals(event.getFile())) {
            this.file.refresh(true, false, new Runnable(){

                @Override
                public void run() {
                    ImageEditorImpl.this.setValue(ImageEditorImpl.this.file);
                }
            });
        }
    }
}

