/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.io.NettyKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"O\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001!1\u0003\u0004\u0001\u001a\u0003a\u0005\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!\n\u0005\u0005\u0003!9Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\f\u0015\"AA\u0003E\t\u001b\u0005Az!J\b\u0005%!IQ\"\u0001M\b3\rA)!D\u0001\u0019\u0007e1\u00012C\u0007\u0005\u0013\tI\u0011\u0001'\u0006\u0019\u0015\u0015:AA\u0001\u0005\f\u001b\u0011I!!C\u0001\u0019\fa]QE\u0007\u0003\u0003\u00111i\u0011\u0001g\u0004\u001a\r!eQ\u0002B\u0005\u0003\u0013\u0005AZ\u0002G\u0007\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAa\"D\u0001\u0019\u001ce1\u00012C\u0007\u0005\u0013\tI\u0011\u0001'\u0006\u0019\u0015%RA1\u0011\u000f\t\u00065\u0011A\u0012\u0001\r\u00049\u0005\u0001\u0013!U\u0002\u0002\u000b\u0001I\u0013\u0002b!\u001d\u0011\u000fi\u0011\u0001\u0007\u0003\u001d\u0003\u0001\n\u0011kA\u0001\u0006\u0001%jAA\u0011\u0005\t\n5!\u0011BA\u0005\u00021\u0017AR!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0004\t\u000e\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "Lorg/jetbrains/builtInWebServer/NetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "port", "", "processChannel", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/netty/channel/Channel;", "getProcessChannel", "()Ljava/util/concurrent/atomic/AtomicReference;", "addCloseListener", "", "it", "closeProcessConnections", "configureBootstrap", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "connectAgain", "Lorg/jetbrains/concurrency/Promise;", "connectToProcess", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/execution/process/OSProcessHandler;", "processHandler"}, moduleName="built-in-server")
public abstract class SingleConnectionNetService
extends NetService {
    @NotNull
    private final AtomicReference<Channel> processChannel;
    private volatile int port;
    private volatile Bootstrap bootstrap;

    @NotNull
    protected final AtomicReference<Channel> getProcessChannel() {
        return this.processChannel;
    }

    protected abstract void configureBootstrap(@NotNull Bootstrap var1, @NotNull Consumer<String> var2);

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise2, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
        Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap bootstrap = NettyKt.oioClientBootstrap();
        this.configureBootstrap(bootstrap, errorOutputConsumer);
        this.bootstrap = bootstrap;
        this.port = port;
        Channel channel = NettyKt.connect$default(bootstrap, new InetSocketAddress(NetUtils.getLoopbackAddress(), port), promise2, 0, null, 12);
        if (channel != null) {
            void $receiver;
            Channel channel2 = channel;
            Channel it = (Channel)$receiver;
            AsyncPromise<OSProcessHandler> asyncPromise = promise2;
            try {
                this.getProcessChannel().set(it);
                this.addCloseListener(it);
                promise2.setResult((Object)processHandler2);
            }
            catch (Throwable e) {
                void $receiver2;
                $receiver2.setError(e);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Promise<Channel> connectAgain() {
        Unit unit;
        Channel channel = this.processChannel.get();
        if (channel != null) {
            return PromiseKt.resolvedPromise(channel);
        }
        AsyncPromise promise2 = new AsyncPromise();
        Bootstrap bootstrap = this.bootstrap;
        if (bootstrap == null) {
            Intrinsics.throwNpe();
        }
        Channel channel2 = NettyKt.connect$default(bootstrap, new InetSocketAddress(NetUtils.getLoopbackAddress(), this.port), promise2, 0, null, 12);
        if (channel2 != null) {
            Channel $receiver = channel2;
            Channel it = $receiver;
            AsyncPromise asyncPromise = promise2;
            try {
                this.getProcessChannel().set(it);
                this.addCloseListener(it);
                promise2.setResult((Object)it);
            }
            catch (Throwable e) {
                void $receiver2;
                $receiver2.setError(e);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return (Promise)promise2;
    }

    private final void addCloseListener(Channel it) {
        ChannelFuture $receiver = it.closeFuture();
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ SingleConnectionNetService this$0;

            public void operationComplete(ChannelFuture future2) {
                ChannelFuture it = future2;
                Channel channel = it.channel();
                this.this$0.getProcessChannel().compareAndSet(channel, null);
                NettyKt.shutdownIfOio(channel.eventLoop());
            }
            {
                this.this$0 = singleConnectionNetService;
            }
        });
    }

    @Override
    protected void closeProcessConnections() {
        Unit unit;
        Channel channel = this.processChannel.getAndSet(null);
        if (channel != null) {
            Channel $receiver = channel;
            Channel it = $receiver;
            NettyKt.closeAndShutdownEventLoop(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public SingleConnectionNetService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project, null, 2, null);
        this.processChannel = new AtomicReference();
        this.port = -1;
    }
}

