/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointBase;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"s\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\rR\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001C\t\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0002\t\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0003\u0006\u00031\tAa\u0005\u0007\u0001+\u0019!\u0001\u0001#\u0001\u0016\u0007%\tA1\u0001\r\u00023\u0005A\u001a!)\u0002R\u0007\u0005A!!J\u0004\t\u00165\t\u0001dC\r\u0004\u0011/i\u0011\u0001G\u0005&@\u0011\u0011\u0002\u0002D\u0007\u00029\u0001I2\u0001#\u0007\u000e\u0003ai\u0011d\u0001E\u000e\u001b\u0005Ab\"G\u0002\t\u001e5\t\u0001DD\r\u0005\u0011=i!\u0001$\u0001\u0019 e\u0019\u0001\u0002E\u0007\u000219I2\u0001#\t\u000e\u0003a\t\u0012kA\u0001\t$\u0015fAA\u0005\u0005\u0013\u001b\rI\u0011\u0001b\u0001\u0019&e\u0019\u0001bE\u0007\u00029\u0001\t6!\u0001E\u0014KK!!\u0003\u0003\u000b\u000e\u000b%\u0019A\u0011A\u0005\u00021SA*#G\u0002\t\u001a5\t\u0001$D\r\u0004\u0011Mi\u0011\u0001\b\u0001R\u0007\u0005AQ#\n\u0006\u0005\u0017!-RbA\u0005\u0002\t\u0007A*#G\u0002\t\"5\t\u0001$E\u0013\u000b\t/Aa#D\u0002\n\u0003\u0011\r\u0001TE\r\u0004\u0011Mi\u0011\u0001'\u000b&\u0016\u0011\u0011\u0001RF\u0007\u00021-I2\u0001C\n\u000e\u0003q\u0001\u0011kA\u0001\t/\u0015J\u0001rF\u0007\u0004\u0013\u0005!\u0019\u0001'\n\u001a\u0007!\u0019R\"\u0001M\u0015K\u0015A\u0001$D\u0002\n\u0003\u0011\r\u0001TE\u0013)\u0011ci\u0011\u0001'\u000b\u001a\u0007!eQ\"\u0001\r\u000e3\rAY\"D\u0001\u0019\u001de\u0019\u0001RD\u0007\u000219IB\u0001C\b\u000e\u00051\u0005\u0001tD\r\u0004\u0011Ai\u0011\u0001\u0007\b\u001a\u0007!\u0005R\"\u0001\r\u00123-A\u0011$D\u0005\n\r%)\u0011b\u0001C\u0001\u0013\u0005AJ\u0003'\n\r\u0002aM\u0012\u0006\u0005\u0003C\u0011!\u0015QbB\u0005\u0003\u0013\u0005a\u0002!\u0003\u0002\n\u0003q\u0001\u0001dA)\u0004\t\u0015\u0001QB\u0001C\u0004\u0011\u0011I\u0003\u0005B&\t\u0011\u0013iq#\u0003\u0004\n\u000bA-QC\u0001G\u00019\u0001a\u0002\u0001e\u0003\u0016\u0016%1\u0011\"\u0002I\u0006+\ta\t\u0001\b\u0001\u001d\u0001a5\u0011kA\u0001\u0005\ra)\u0011kA\u0001\u0005\rE\u001bA!\u0002\u0001\u000e\u0005\u00119\u0001rB\u0015\u000e\t\tC\u0001\u0002C\u0007\u0005\u0013\tI\u0011\u0001G\u0005\u0019\u0012E\u001bA!\u0002\u0001\u000e\u0005\u0011M\u0001B\u0003"}, strings={"Lorg/jetbrains/debugger/BreakpointManagerBase;", "T", "Lorg/jetbrains/debugger/BreakpointBase;", "Lorg/jetbrains/debugger/BreakpointManager;", "()V", "breakpointDuplicationByTarget", "Ljava/util/concurrent/ConcurrentMap;", "getBreakpointDuplicationByTarget", "()Ljava/util/concurrent/ConcurrentMap;", "breakpoints", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getBreakpoints", "()Ljava/util/Set;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/debugger/BreakpointListener;", "getDispatcher", "()Lcom/intellij/util/EventDispatcher;", "addBreakpointListener", "", "listener", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "", "(Lorg/jetbrains/debugger/BreakpointTarget;IILjava/lang/String;IZ)Lorg/jetbrains/debugger/BreakpointBase;", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "breakpoint", "(Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "(Lorg/jetbrains/debugger/BreakpointTarget;Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "enableBreakpoints", "flush", "notifyBreakpointResolvedListener", "(Lorg/jetbrains/debugger/BreakpointBase;)V", "remove", "removeAll", "setBreakpoint", "promiseRef", "Lcom/intellij/openapi/util/Ref;"}, moduleName="script-debugger-backend")
public abstract class BreakpointManagerBase<T extends BreakpointBase<?>>
implements BreakpointManager {
    @NotNull
    private final Set<T> breakpoints = ContainerUtil.newConcurrentSet();
    @NotNull
    private final ConcurrentMap<T, T> breakpointDuplicationByTarget;
    @NotNull
    private final EventDispatcher<BreakpointListener> dispatcher;

    @NotNull
    public Set<T> getBreakpoints() {
        return this.breakpoints;
    }

    @NotNull
    protected final ConcurrentMap<T, T> getBreakpointDuplicationByTarget() {
        return this.breakpointDuplicationByTarget;
    }

    @NotNull
    protected final EventDispatcher<BreakpointListener> getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    protected abstract T createBreakpoint(@NotNull BreakpointTarget var1, int var2, int var3, @Nullable String var4, int var5, boolean var6);

    @NotNull
    protected abstract Promise<? extends Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget var1, @NotNull T var2);

    @Override
    @NotNull
    public final Breakpoint setBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled, @Nullable Ref<Promise<? extends Breakpoint>> promiseRef) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        T breakpoint = this.createBreakpoint(target, line, column, condition, ignoreCount, enabled);
        BreakpointBase existingBreakpoint = (BreakpointBase)this.breakpointDuplicationByTarget.putIfAbsent(breakpoint, breakpoint);
        if (existingBreakpoint != null) {
            Unit unit;
            Ref<Promise<? extends Breakpoint>> ref = promiseRef;
            if (ref != null) {
                ref.set(PromiseKt.resolvedPromise(breakpoint));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return existingBreakpoint;
        }
        this.getBreakpoints().add(breakpoint);
        if (enabled) {
            Unit unit;
            Promise promise2 = this.doSetBreakpoint(target, breakpoint).rejected((Consumer)new Consumer<Throwable>(this, (BreakpointBase)breakpoint){
                final /* synthetic */ BreakpointManagerBase this$0;
                final /* synthetic */ BreakpointBase $breakpoint;

                public final void consume(Throwable it) {
                    BreakpointListener breakpointListener = (BreakpointListener)this.this$0.getDispatcher().getMulticaster();
                    Breakpoint breakpoint = this.$breakpoint;
                    String string = it.getMessage();
                    if (string == null) {
                        string = it.toString();
                    }
                    breakpointListener.errorOccurred(breakpoint, string);
                }
                {
                    this.this$0 = breakpointManagerBase;
                    this.$breakpoint = breakpointBase;
                }
            });
            Ref<Promise<? extends Breakpoint>> ref = promiseRef;
            if (ref != null) {
                ref.set((Object)promise2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            Unit unit;
            Ref<Promise<? extends Breakpoint>> ref = promiseRef;
            if (ref != null) {
                ref.set(PromiseKt.resolvedPromise(breakpoint));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        return (Breakpoint)breakpoint;
    }

    @Override
    @NotNull
    public final Promise<?> remove(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        Breakpoint breakpoint2 = breakpoint;
        if (breakpoint2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        BreakpointBase b = (BreakpointBase)breakpoint2;
        boolean existed = this.getBreakpoints().remove(b);
        if (existed) {
            this.breakpointDuplicationByTarget.remove(b);
        }
        return !existed || !b.isVmRegistered() ? PromiseKt.resolvedPromise() : this.doClearBreakpoint(b);
    }

    @Override
    @NotNull
    public final Promise<?> removeAll() {
        List list = CollectionsKt.toList((Iterable)this.getBreakpoints());
        this.getBreakpoints().clear();
        this.breakpointDuplicationByTarget.clear();
        SmartList promises = new SmartList();
        for (BreakpointBase b : list) {
            if (!b.isVmRegistered()) continue;
            BreakpointBase breakpointBase = b;
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpointBase, (String)"b");
            promises.add(this.doClearBreakpoint(breakpointBase));
        }
        Promise promise2 = Promise.all((Collection)((Collection)promises));
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.all(promises)");
        return promise2;
    }

    @NotNull
    protected abstract Promise<?> doClearBreakpoint(@NotNull T var1);

    @Override
    public final void addBreakpointListener(@NotNull BreakpointListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    protected final void notifyBreakpointResolvedListener(@NotNull T breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        if (((BreakpointBase)breakpoint).isResolved()) {
            ((BreakpointListener)this.dispatcher.getMulticaster()).resolved((Breakpoint)breakpoint);
        }
    }

    @Override
    @NotNull
    public Promise<?> flush(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        Breakpoint breakpoint2 = breakpoint;
        if (breakpoint2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return ((BreakpointBase)breakpoint2).flush(this);
    }

    @Override
    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        return PromiseKt.rejectedPromise("Unsupported");
    }

    public BreakpointManagerBase() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)new TObjectHashingStrategy<T>(){

            public int computeHashCode(@NotNull T b) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                int result2 = ((BreakpointBase)b).getLine();
                result2 *= 31 + ((BreakpointBase)b).getColumn();
                if (((BreakpointBase)b).getCondition() != null) {
                    String string = ((BreakpointBase)b).getCondition();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    result2 *= 31 + string.hashCode();
                }
                return result2 *= 31 + ((BreakpointBase)b).getTarget().hashCode();
            }

            public boolean equals(@NotNull T b1, @NotNull T b2) {
                Intrinsics.checkParameterIsNotNull(b1, (String)"b1");
                Intrinsics.checkParameterIsNotNull(b2, (String)"b2");
                return Intrinsics.areEqual(((BreakpointBase)b1).getTarget().getClass(), ((BreakpointBase)b2).getTarget().getClass()) && Intrinsics.areEqual((Object)((BreakpointBase)b1).getTarget(), (Object)((BreakpointBase)b2).getTarget()) && ((BreakpointBase)b1).getLine() == ((BreakpointBase)b2).getLine() && ((BreakpointBase)b1).getColumn() == ((BreakpointBase)b2).getColumn() && StringUtil.equals((CharSequence)((BreakpointBase)b1).getCondition(), (CharSequence)((BreakpointBase)b2).getCondition());
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurr\u2026ition, b2.condition)\n  })");
        this.breakpointDuplicationByTarget = concurrentMap;
        EventDispatcher eventDispatcher = EventDispatcher.create(BreakpointListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(B\u2026ointListener::class.java)");
        this.dispatcher = eventDispatcher;
    }

    @Override
    public boolean getRegExpBreakpointSupported() {
        return BreakpointManager.DefaultImpls.getRegExpBreakpointSupported(this);
    }

    @Override
    @Nullable
    public Function1<String, BreakpointTarget> getFunctionSupport() {
        return BreakpointManager.DefaultImpls.getFunctionSupport(this);
    }

    @Override
    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        return BreakpointManager.DefaultImpls.getMuteMode(this);
    }
}

