/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001#\u0005\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u000e\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001\u0003\t\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0011)\u0011\u0001B\u0002\u0006\u00031\tA\u0002A\r\u00021\u0003\t;$\u0003\u0003\t\u00035\u0011A\u0012\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006%9\u0001bA\u0007\u0006\u0013\rI!\u0001$\u0001\u0019\u0006a\u001d\u0011b\u0001\u0005\u0005\u001b\u0005AJ!C\u0002\t\u000b5\t\u00014B)\u0004\u0003!1Q\u0005\u0007\u0005\u000f\u001b\ta\t\u0001'\u0002\u001a\r!uQ\u0002B\u0005\u0003\u0013\u0005AJ\u0002G\b\u001a\t!}QB\u0001G\u00011AIr\u0001#\t\u000e\u000b%\u0011\u0011\"\u0001M\u0012\u0019\u0003A\u0012#J\u0004\t%5\t\u0001TA\r\u0004\u0011Ki\u0011\u0001G\n&\u0017!\u001dR\"\u0001\r\u00143\rAA#D\u0001\u0019'e\u0019\u0001\u0012F\u0007\u00021M)s\u0004C\u000b\u000e\u0003a-\u0011D\u0002E\u000f\u001b\u0011I!!C\u0001\u0019\u001aay\u0011d\u0001E\u0016\u001b\u0005A2#G\u0002\t-5\t\u0001TF\r\u0005\u0011?i!\u0001$\u0001\u0019!e9\u0001\u0012E\u0007\u0006\u0013\tI\u0011\u0001g\t\r\u0002a\t\u0012F\u0003\u0003D\u0011!)Q\"\u0001M\u0006#\u000e!Q\u0001A\u0007\u0003\t\u001bAq!\u000b\u0006\u0005\u0007\"A!!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011=\u0001\u0002C\u0015\f\t\rC\u0001\"A\u0007\u0003\u0019\u0003A\u001a!U\u0002\u0005\u000b\u0001i!\u0001\"\u0005\t\u0013%zA\u0001\u0011\u0005\t\u00075)\u0011bA\u0005\u0003\u0019\u0003A*\u0001g\u0002R\u0007\u0015)\u0011\u0001#\u0006\u000e\u0005\u0011M\u0001BC\u0015\u000b\t\rC\u0001\u0002B\u0007\u00021\u0013\t6\u0001B\u0003\u0001\u001b\t!1\u0002c\u0006*\u001b\u0011\u0019\u0005\u0002\u0003\u0007\u000e\t%\u0011\u0011\"\u0001M\r1\u000fa2%U\u0002\u0004\u001b\t!Q\u0002c\u0007"}, strings={"Lorg/jetbrains/debugger/sourcemap/SourceMap;", "", "outFile", "", "mappings", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceIndexToMappings", "", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "hasNameMappings", "", "(Ljava/lang/String;Lorg/jetbrains/debugger/sourcemap/MappingList;[Lorg/jetbrains/debugger/sourcemap/MappingList;Lorg/jetbrains/debugger/sourcemap/SourceResolver;Z)V", "getHasNameMappings", "()Z", "getMappings", "()Lorg/jetbrains/debugger/sourcemap/MappingList;", "getOutFile", "()Ljava/lang/String;", "getSourceIndexToMappings$script_debugger_backend", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "[Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "findMappingList", "sourceUrls", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lcom/intellij/openapi/util/NullableLazyValue;", "Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "getMappingsOrderedBySource", "source", "", "getSourceLineByRawLocation", "rawLine", "rawColumn", "processMappingsInLine", "sourceLine", "mappingProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingList$MappingsProcessorInLine;"}, moduleName="script-debugger-backend")
public final class SourceMap {
    @Nullable
    private final String outFile;
    @NotNull
    private final MappingList mappings;
    @NotNull
    private final MappingList[] sourceIndexToMappings;
    @NotNull
    private final SourceResolver sourceResolver;
    private final boolean hasNameMappings;

    @NotNull
    public final Url[] getSources() {
        return this.sourceResolver.getCanonicalizedUrls$script_debugger_backend();
    }

    public final int getSourceLineByRawLocation(int rawLine, int rawColumn) {
        MappingEntry mappingEntry = this.mappings.get(rawLine, rawColumn);
        return mappingEntry != null ? mappingEntry.getSourceLine() : -1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MappingList findMappingList(@NotNull List<? extends Url> sourceUrls, @Nullable VirtualFile sourceFile, @Nullable NullableLazyValue<SourceResolver.Resolver> resolver) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        MappingList mappings = this.sourceResolver.findMappings(sourceUrls, this, sourceFile);
        if (mappings == null && resolver != null) {
            MappingList mappingList;
            SourceResolver.Resolver resolver2 = (SourceResolver.Resolver)resolver.getValue();
            if (resolver2 != null) {
                void $receiver;
                SourceResolver.Resolver resolver3 = resolver2;
                SourceResolver.Resolver it = (SourceResolver.Resolver)$receiver;
                SourceResolver sourceResolver = this.getSourceResolver();
                SourceResolver.Resolver resolver4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolver4, (String)"it");
                mappingList = sourceResolver.findMappings(sourceFile, this, resolver4);
            } else {
                mappingList = null;
            }
            mappings = mappingList;
        }
        return mappings;
    }

    public final boolean processMappingsInLine(@NotNull List<? extends Url> sourceUrls, int sourceLine, @NotNull MappingList.MappingsProcessorInLine mappingProcessor, @Nullable VirtualFile sourceFile, @Nullable NullableLazyValue<SourceResolver.Resolver> resolver) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)mappingProcessor, (String)"mappingProcessor");
        MappingList mappings = this.findMappingList(sourceUrls, sourceFile, resolver);
        return mappings != null && mappings.processMappingsInLine(sourceLine, mappingProcessor);
    }

    @NotNull
    public final MappingList getMappingsOrderedBySource(int source) {
        MappingList mappingList = this.sourceIndexToMappings[source];
        if (mappingList == null) {
            Intrinsics.throwNpe();
        }
        return mappingList;
    }

    @Nullable
    public final String getOutFile() {
        return this.outFile;
    }

    @NotNull
    public final MappingList getMappings() {
        return this.mappings;
    }

    @NotNull
    public final MappingList[] getSourceIndexToMappings$script_debugger_backend() {
        return this.sourceIndexToMappings;
    }

    @NotNull
    public final SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public final boolean getHasNameMappings() {
        return this.hasNameMappings;
    }

    public SourceMap(@Nullable String outFile, @NotNull MappingList mappings, @NotNull MappingList[] sourceIndexToMappings, @NotNull SourceResolver sourceResolver, boolean hasNameMappings) {
        Intrinsics.checkParameterIsNotNull((Object)mappings, (String)"mappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceIndexToMappings, (String)"sourceIndexToMappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceResolver, (String)"sourceResolver");
        this.outFile = outFile;
        this.mappings = mappings;
        this.sourceIndexToMappings = sourceIndexToMappings;
        this.sourceResolver = sourceResolver;
        this.hasNameMappings = hasNameMappings;
    }
}

