/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.values.ValueBase;
import org.jetbrains.debugger.values.ValueType;

public class PrimitiveValue
extends ValueBase {
    public static final String NA_N_VALUE = "NaN";
    public static final String INFINITY_VALUE = "Infinity";
    public static final PrimitiveValue NULL = new PrimitiveValue(ValueType.NULL, "null");
    public static final PrimitiveValue UNDEFINED = new PrimitiveValue(ValueType.UNDEFINED, "undefined");
    public static final PrimitiveValue NAN = new PrimitiveValue(ValueType.NUMBER, "NaN");
    public static final PrimitiveValue INFINITY = new PrimitiveValue(ValueType.NUMBER, "Infinity");
    private static final PrimitiveValue TRUE = new PrimitiveValue(ValueType.BOOLEAN, "true");
    private static final PrimitiveValue FALSE = new PrimitiveValue(ValueType.BOOLEAN, "false");
    private final String valueString;

    public PrimitiveValue(@NotNull ValueType type, @NotNull String valueString) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/debugger/values/PrimitiveValue", "<init>"));
        }
        if (valueString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueString", "org/jetbrains/debugger/values/PrimitiveValue", "<init>"));
        }
        super(type);
        this.valueString = valueString;
    }

    @NotNull
    public static PrimitiveValue bool(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/values/PrimitiveValue", "bool"));
        }
        PrimitiveValue primitiveValue = value.equals("true") ? TRUE : FALSE;
        if (primitiveValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/PrimitiveValue", "bool"));
        }
        return primitiveValue;
    }

    public PrimitiveValue(ValueType type, int value) {
        this(type, Integer.toString(value));
    }

    public PrimitiveValue(ValueType type, long value) {
        this(type, Long.toString(value));
    }

    @Override
    @Nullable
    public final String getValueString() {
        return this.valueString;
    }
}

