/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.NettyUtil;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\u0001Q!\u0001\u0005\b\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!$\u0003\t\u000b5\t\u00014\u0002+\u0004\u00065%Ba\u0011\t\t\r5\t\u0001TB\u000b\u00021\u001dI:\u0002\u0002\u0002\t\u001059\u0011BA\u0005\u00021\u001dI!!C\u0001\u0019\u000eaA\u0001k!\u0001U\u0007\u000bii\u0001#\u0005\u000e\u0003a5Q#\u0001M\u0004)\u000e\u0015Q\u0012\u000bC\u0004\u0011%i!\u0001$\u0001\u0019\bU\t\u00014BM\u0005\u0011'i\u0011\u0001\u0007\u0006Q\u0007\u0003I\n\u0002B\u0001\t\u00165!\u0011\"\u0001C\u0002\u0019\u0003A2\u0002U\u0002\u00023\u0017!\u0011\u0001c\u0006\u000e\u0003aa\u0001ka\u0001\u001a\u0014\u0011\t\u0001\u0012D\u0007\u0006\u0013\tI\u0011\u0001g\u0007\r\u0002ai\u0001k\u0001\u0002U\u0007\u000biI\u0003B\"\u0011\u00119i\u0011\u0001g\u0003\u0016\u0003a-\u0011t\u0003\u0003\u0003\u0011;iq!\u0003\u0002\n\u0003a\u001d\u0011BA\u0005\u00021\u001bA\u0002\u0002UB\u0001)\u000e\u0015QR\u0002\u0005\u0010\u001b\u0005Aj!F\u0001\u0019 Q\u001b)!e\u0007\u0005\u0007\"A\u0001!D\u0001\u0019\u0002U\t\u0001$\u0001\u000f$#\u000e\u0019QB\u0001C\u0002\u0011\t!6QAI\u000e\t\rC\u0001bA\u0007\u00021\u0003)\u0012\u0001g\u0002\u001dGE\u001b1!\u0004\u0002\u0005\t!%Ak!\u0002"}, strings={"host", "", "Lio/netty/handler/codec/http/HttpRequest;", "getHost", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "NettyKt", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "oioClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "addListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "closeAndShutdownEventLoop", "connect", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "handler", "task", "shutdownIfOio", "Lio/netty/channel/EventLoop;"}, moduleName="platform-impl")
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(Bootstrap $receiver, @NotNull Function1<? super Channel, ? extends Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    public static final void addListener(ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, ? extends Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener){
            final /* synthetic */ Function1 $listener;

            public void operationComplete(@NotNull ChannelFuture future2) {
                Intrinsics.checkParameterIsNotNull((Object)future2, (String)"future");
                this.$listener.invoke((Object)future2);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public static final void shutdownIfOio(EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            EventLoop eventLoop = $receiver;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.oio.OioEventLoopGroup");
            }
            ((OioEventLoopGroup)eventLoop).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                condition = Conditions.alwaysFalse();
            }
            return NettyUtil.doConnect($receiver, remoteAddress, promise2, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            AsyncPromise<?> asyncPromise = promise2;
            Boolean bl = asyncPromise != null ? Boolean.valueOf(asyncPromise.setError(e)) : null;
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n, Condition condition, int n2) {
        if ((n2 & 2) != 0) {
            asyncPromise = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            condition = null;
        }
        return NettyKt.connect(bootstrap, inetSocketAddress, asyncPromise, n, (Condition<Void>)condition);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, @NotNull AsyncPromise<?> asyncPromise, int n) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, n, null, 8);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, AsyncPromise<?> asyncPromise) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, 0, null, 12);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, InetSocketAddress inetSocketAddress) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, null, 0, null, 14);
    }

    @NotNull
    public static final String getUriScheme(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @NotNull
    public static final String getHost(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"headers().getAsString(HttpHeaderNames.HOST)");
        return string;
    }
}

