/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.GenerateToStringClassFilter;
import org.jetbrains.java.generate.GenerateToStringActionHandler;
import org.jetbrains.java.generate.GenerateToStringConfigurable;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.GenerateToStringWorker;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.config.Config;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.toString.ToStringTemplatesManager;
import org.jetbrains.java.generate.view.TemplatesPanel;

public class GenerateToStringActionHandlerImpl
implements GenerateToStringActionHandler,
CodeInsightActionHandler {
    private static final Logger logger = Logger.getInstance((String)"#GenerateToStringActionHandlerImpl");

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/generate/GenerateToStringActionHandlerImpl", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/java/generate/GenerateToStringActionHandlerImpl", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/java/generate/GenerateToStringActionHandlerImpl", "invoke"));
        }
        PsiClass clazz = GenerateToStringActionHandlerImpl.getSubjectClass(editor, file);
        assert (clazz != null);
        GenerateToStringActionHandlerImpl.doExecuteAction(project, clazz, editor);
    }

    @Override
    public void executeActionQuickFix(Project project, PsiClass clazz) {
        GenerateToStringActionHandlerImpl.doExecuteAction(project, clazz, null);
    }

    private static void doExecuteAction(final @NotNull Project project, final @NotNull PsiClass clazz, final Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/generate/GenerateToStringActionHandlerImpl", "doExecuteAction"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/java/generate/GenerateToStringActionHandlerImpl", "doExecuteAction"));
        }
        logger.debug("+++ doExecuteAction - START +++");
        if (logger.isDebugEnabled()) {
            logger.debug("Current project " + project.getName());
        }
        final PsiElementClassMember[] dialogMembers = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz);
        final MemberChooserHeaderPanel header = new MemberChooserHeaderPanel(clazz);
        logger.debug("Displaying member chooser dialog");
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                MemberChooser<PsiElementClassMember> chooser = new MemberChooser<PsiElementClassMember>(dialogMembers, true, true, project, PsiUtil.isLanguageLevel5OrHigher((PsiElement)clazz), (JComponent)header){

                    @Nullable
                    protected String getHelpId() {
                        return "editing.altInsert.tostring";
                    }
                };
                chooser.setTitle("Generate toString()");
                chooser.setCopyJavadocVisible(false);
                chooser.selectElements(dialogMembers);
                header.setChooser(chooser);
                chooser.show();
                if (0 == chooser.getExitCode()) {
                    List<PsiMember> selectedMembers = GenerationUtil.convertClassMembersToPsiMembers(chooser.getSelectedElements());
                    TemplateResource template = header.getSelectedTemplate();
                    ToStringTemplatesManager.getInstance().setDefaultTemplate(template);
                    if (template.isValidTemplate()) {
                        GenerateToStringWorker.executeGenerateActionLater(clazz, editor, selectedMembers, template, chooser.isInsertOverrideAnnotation());
                    } else {
                        HintManager.getInstance().showErrorHint(editor, "toString() template '" + template.getFileName() + "' is invalid");
                    }
                }
            }
        });
        logger.debug("+++ doExecuteAction - END +++");
    }

    public static void updateDialog(PsiClass clazz, MemberChooser<PsiElementClassMember> dialog) {
        ClassMember[] members = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz);
        dialog.resetElements(members);
        dialog.selectElements(members);
    }

    private static PsiElementClassMember[] buildMembersToShow(PsiClass clazz) {
        PsiMethod[] filteredMethods;
        Config config = GenerateToStringContext.getConfig();
        PsiField[] filteredFields = GenerateToStringUtils.filterAvailableFields(clazz, config.getFilterPattern());
        if (logger.isDebugEnabled()) {
            logger.debug("Number of fields after filtering: " + filteredFields.length);
        }
        if (config.enableMethods) {
            filteredMethods = GenerateToStringUtils.filterAvailableMethods(clazz, config.getFilterPattern());
            if (logger.isDebugEnabled()) {
                logger.debug("Number of methods after filtering: " + filteredMethods.length);
            }
        } else {
            filteredMethods = PsiMethod.EMPTY_ARRAY;
        }
        return GenerationUtil.combineToClassMemberList(filteredFields, filteredMethods);
    }

    @Nullable
    private static PsiClass getSubjectClass(Editor editor, PsiFile file) {
        if (file == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement context = file.findElementAt(offset);
        if (context == null) {
            return null;
        }
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class, (boolean)false);
        if (clazz == null) {
            return null;
        }
        for (GenerateToStringClassFilter filter : (GenerateToStringClassFilter[])GenerateToStringClassFilter.EP_NAME.getExtensions()) {
            if (filter.canGenerateToString(clazz)) continue;
            return null;
        }
        return clazz;
    }

    public static class MemberChooserHeaderPanel
    extends JPanel {
        private MemberChooser<PsiElementClassMember> chooser;
        private final JComboBox comboBox;

        public void setChooser(MemberChooser chooser) {
            this.chooser = chooser;
        }

        public MemberChooserHeaderPanel(final PsiClass clazz) {
            super(new GridBagLayout());
            Collection<TemplateResource> templates = ToStringTemplatesManager.getInstance().getAllTemplates();
            Object[] all = templates.toArray(new TemplateResource[templates.size()]);
            JButton settingsButton = new JButton("Settings");
            settingsButton.setMnemonic(83);
            this.comboBox = new ComboBox(all);
            settingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final TemplatesPanel ui = new TemplatesPanel(clazz.getProject());
                    Disposable disposable = Disposer.newDisposable();
                    TabbedConfigurable composite = new TabbedConfigurable(disposable){

                        @Override
                        protected List<Configurable> createConfigurables() {
                            ArrayList<Configurable> res = new ArrayList<Configurable>();
                            res.add(new GenerateToStringConfigurable(clazz.getProject()));
                            res.add((Configurable)ui);
                            return res;
                        }

                        public String getDisplayName() {
                            return "toString() Generation Settings";
                        }

                        public String getHelpTopic() {
                            return "editing.altInsert.tostring.settings";
                        }

                        @Override
                        public void apply() throws ConfigurationException {
                            super.apply();
                            GenerateToStringActionHandlerImpl.updateDialog(clazz, MemberChooserHeaderPanel.this.chooser);
                            MemberChooserHeaderPanel.this.comboBox.removeAllItems();
                            for (TemplateResource resource : ToStringTemplatesManager.getInstance().getAllTemplates()) {
                                MemberChooserHeaderPanel.this.comboBox.addItem(resource);
                            }
                            MemberChooserHeaderPanel.this.comboBox.setSelectedItem(ToStringTemplatesManager.getInstance().getDefaultTemplate());
                        }
                    };
                    ShowSettingsUtil.getInstance().editConfigurable((Component)MemberChooserHeaderPanel.this, (Configurable)composite, new Runnable(){

                        @Override
                        public void run() {
                            ui.selectItem(ToStringTemplatesManager.getInstance().getDefaultTemplate());
                        }
                    });
                    Disposer.dispose((Disposable)disposable);
                }
            });
            this.comboBox.setSelectedItem(ToStringTemplatesManager.getInstance().getDefaultTemplate());
            JLabel templatesLabel = new JLabel("Template: ");
            templatesLabel.setDisplayedMnemonic('T');
            templatesLabel.setLabelFor(this.comboBox);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 256;
            constraints.gridx = 0;
            this.add((Component)templatesLabel, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            this.add((Component)this.comboBox, constraints);
            constraints.gridx = 2;
            constraints.weightx = 0.0;
            this.add((Component)settingsButton, constraints);
        }

        public TemplateResource getSelectedTemplate() {
            return (TemplateResource)this.comboBox.getSelectedItem();
        }
    }
}

