/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.output;

import com.android.annotations.NonNull;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;

public class GradleMessageRewriter {
    public static final String STDOUT_ERROR_TAG = "AGPBI: ";
    private final ToolOutputParser mParser;
    private final Gson mGson;
    private final ErrorFormatMode mErrorFormatMode;

    public GradleMessageRewriter(ToolOutputParser parser, ErrorFormatMode errorFormatMode) {
        this.mParser = parser;
        this.mErrorFormatMode = errorFormatMode;
        this.mGson = GradleMessageRewriter.createGson();
    }

    public String rewriteMessages(@NonNull String originalMessage) {
        List<Message> messages = this.mParser.parseToolOutput(originalMessage);
        if (messages.isEmpty()) {
            return originalMessage;
        }
        StringBuilder errorStringBuilder = new StringBuilder();
        for (Message message : messages) {
            if (this.mErrorFormatMode == ErrorFormatMode.HUMAN_READABLE) {
                for (SourceFilePosition pos : message.getSourceFilePositions()) {
                    errorStringBuilder.append(pos.toString());
                    errorStringBuilder.append(' ');
                }
                if (errorStringBuilder.length() > 0) {
                    errorStringBuilder.append(": ");
                }
                errorStringBuilder.append(message.getText()).append("\n");
                continue;
            }
            errorStringBuilder.append(STDOUT_ERROR_TAG).append(this.mGson.toJson((Object)message)).append("\n");
        }
        return errorStringBuilder.toString();
    }

    private static Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        MessageJsonSerializer.registerTypeAdapters(gsonBuilder);
        return gsonBuilder.create();
    }

    public static enum ErrorFormatMode {
        MACHINE_PARSABLE,
        HUMAN_READABLE;

    }
}

