/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HardwareConfigHelper {
    @NonNull
    private final Device mDevice;
    @NonNull
    private ScreenOrientation mScreenOrientation = ScreenOrientation.PORTRAIT;
    private int mMaxRenderWidth = -1;
    private int mMaxRenderHeight = -1;
    private int mOverrideRenderWidth = -1;
    private int mOverrideRenderHeight = -1;
    public static final String MANUFACTURER_GENERIC = "Generic";
    private static final String NEXUS = "Nexus";
    private static final Pattern GENERIC_PATTERN = Pattern.compile("(\\d+\\.?\\d*)\" (.+?)( \\(.*Nexus.*\\))?");
    private static final String ID_PREFIX_WEAR = "wear_";
    private static final String ID_PREFIX_WEAR_ROUND = "wear_round";
    private static final String ID_PREFIX_TV = "tv_";

    public HardwareConfigHelper(@NonNull Device device) {
        this.mDevice = device;
    }

    @NonNull
    public HardwareConfigHelper setOrientation(@NonNull ScreenOrientation screenOrientation) {
        this.mScreenOrientation = screenOrientation;
        return this;
    }

    @NonNull
    public HardwareConfigHelper setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.mOverrideRenderWidth = overrideRenderWidth;
        this.mOverrideRenderHeight = overrideRenderHeight;
        return this;
    }

    @NonNull
    public HardwareConfigHelper setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.mMaxRenderWidth = maxRenderWidth;
        this.mMaxRenderHeight = maxRenderHeight;
        return this;
    }

    @NonNull
    public HardwareConfig getConfig() {
        int height;
        int width;
        int y;
        Screen screen = this.mDevice.getDefaultHardware().getScreen();
        int x = screen.getXDimension();
        if (x > (y = screen.getYDimension())) {
            if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
                width = x;
                height = y;
            } else {
                width = y;
                height = x;
            }
        } else if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
            width = y;
            height = x;
        } else {
            width = x;
            height = y;
        }
        if (this.mOverrideRenderHeight != -1) {
            width = this.mOverrideRenderWidth;
        }
        if (this.mOverrideRenderHeight != -1) {
            height = this.mOverrideRenderHeight;
        }
        if (this.mMaxRenderWidth != -1) {
            width = this.mMaxRenderWidth;
        }
        if (this.mMaxRenderHeight != -1) {
            height = this.mMaxRenderHeight;
        }
        return new HardwareConfig(width, height, screen.getPixelDensity(), (float)screen.getXdpi(), (float)screen.getYdpi(), screen.getSize(), this.mScreenOrientation, this.mDevice.getDefaultHardware().getScreen().getScreenRound(), this.mDevice.getDefaultHardware().getButtonType() == ButtonType.SOFT);
    }

    @NonNull
    public static String getNexusLabel(@NonNull Device device) {
        String name = device.getDisplayName();
        Screen screen = device.getDefaultHardware().getScreen();
        float length = (float)screen.getDiagonalLength();
        length = (float)Math.round(10.0f * length) / 10.0f;
        return String.format(Locale.US, "%1$s (%3$s\", %2$s)", name, HardwareConfigHelper.getResolutionString(device), Float.toString(length));
    }

    @NonNull
    public static String getGenericLabel(@NonNull Device device) {
        String name = device.getDisplayName();
        Matcher matcher = GENERIC_PATTERN.matcher(name);
        if (matcher.matches()) {
            String size = matcher.group(1);
            String n = matcher.group(2);
            int dot = size.indexOf(46);
            if (dot == -1) {
                size = size + ".0";
                dot = size.length() - 2;
            }
            for (int i = 0; i < 2 - dot; ++i) {
                size = ' ' + size;
            }
            name = size + "\" " + n;
        }
        return String.format(Locale.US, "%1$s (%2$s)", name, HardwareConfigHelper.getResolutionString(device));
    }

    @NonNull
    public static String getResolutionString(@NonNull Device device) {
        Screen screen = device.getDefaultHardware().getScreen();
        return String.format(Locale.US, "%1$d \u00d7 %2$d: %3$s", screen.getXDimension(), screen.getYDimension(), screen.getPixelDensity().getResourceValue());
    }

    public static boolean isGeneric(@NonNull Device device) {
        return device.getManufacturer().equals(MANUFACTURER_GENERIC);
    }

    public static boolean isNexus(@NonNull Device device) {
        return device.getId().contains(NEXUS);
    }

    public static boolean isWear(@Nullable Device device) {
        return device != null && device.getId().startsWith(ID_PREFIX_WEAR);
    }

    public static boolean isTv(@Nullable Device device) {
        return device != null && device.getId().startsWith(ID_PREFIX_TV);
    }

    public static int nexusRank(Device device) {
        String id = device.getId();
        if (id.equals("Nexus One")) {
            return 1;
        }
        if (id.equals("Nexus S")) {
            return 2;
        }
        if (id.equals("Galaxy Nexus")) {
            return 3;
        }
        if (id.equals("Nexus 7")) {
            return 4;
        }
        if (id.equals("Nexus 10")) {
            return 5;
        }
        if (id.equals("Nexus 4")) {
            return 6;
        }
        if (id.equals("Nexus 7 2013")) {
            return 7;
        }
        if (id.equals("Nexus 5")) {
            return 8;
        }
        if (id.equals("Nexus 9")) {
            return 9;
        }
        if (id.equals("Nexus 6")) {
            return 10;
        }
        return 100;
    }

    public static void sortNexusList(@NonNull List<Device> list) {
        Collections.sort(list, new Comparator<Device>(){

            @Override
            public int compare(Device device1, Device device2) {
                return HardwareConfigHelper.nexusRank(device2) - HardwareConfigHelper.nexusRank(device1);
            }
        });
    }
}

