/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Header;
import org.apache.tools.ant.taskdefs.email.Mailer;

public class MimeMailer
extends Mailer {
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final String GENERIC_ERROR = "Problem while sending mime mail:";
    private static final String DEFAULT_CHARSET = System.getProperty("file.encoding");

    public void send() {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.host);
            props.put("mail.smtp.port", String.valueOf(this.port));
            SimpleAuthenticator auth = null;
            if (this.SSL) {
                try {
                    Provider p = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                    Security.addProvider(p);
                }
                catch (Exception e) {
                    throw new BuildException("could not instantiate ssl security provider, check that you have JSSE in your classpath");
                }
                props.put("mail.smtp.socketFactory.class", SSL_FACTORY);
                props.put("mail.smtp.socketFactory.fallback", "false");
                props.put("mail.smtps.host", this.host);
                if (this.isPortExplicitlySpecified()) {
                    props.put("mail.smtps.port", String.valueOf(this.port));
                    props.put("mail.smtp.socketFactory.port", String.valueOf(this.port));
                }
            }
            if (this.user != null || this.password != null) {
                props.put("mail.smtp.auth", "true");
                auth = new SimpleAuthenticator(this.user, this.password);
            }
            if (this.isStartTLSEnabled()) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            Session sesh = Session.getInstance((Properties)props, auth);
            MimeMessage msg = new MimeMessage(sesh);
            MimeMultipart attachments = new MimeMultipart();
            if (this.from.getName() == null) {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress()));
            } else {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress(), this.from.getName()));
            }
            msg.setReplyTo((Address[])MimeMailer.internetAddresses(this.replyToList));
            msg.setRecipients(Message.RecipientType.TO, (Address[])MimeMailer.internetAddresses(this.toList));
            msg.setRecipients(Message.RecipientType.CC, (Address[])MimeMailer.internetAddresses(this.ccList));
            msg.setRecipients(Message.RecipientType.BCC, (Address[])MimeMailer.internetAddresses(this.bccList));
            String charset = this.parseCharSetFromMimeType(this.message.getMimeType());
            if (charset != null) {
                this.message.setCharset(charset);
            } else {
                charset = this.message.getCharset();
                if (charset == null) {
                    charset = DEFAULT_CHARSET;
                    this.message.setCharset(charset);
                }
            }
            StringDataSource sds = new StringDataSource();
            sds.setContentType(this.message.getMimeType());
            sds.setCharset(charset);
            if (this.subject != null) {
                msg.setSubject(this.subject, charset);
            }
            msg.addHeader("Date", this.getDate());
            if (this.headers != null) {
                for (Header h : this.headers) {
                    msg.addHeader(h.getName(), h.getValue());
                }
            }
            PrintStream out = new PrintStream(sds.getOutputStream());
            this.message.print(out);
            out.close();
            MimeBodyPart textbody = new MimeBodyPart();
            textbody.setDataHandler(new DataHandler((DataSource)sds));
            attachments.addBodyPart((BodyPart)textbody);
            Enumeration e = this.files.elements();
            while (e.hasMoreElements()) {
                File file = (File)e.nextElement();
                MimeBodyPart body = new MimeBodyPart();
                if (!file.exists() || !file.canRead()) {
                    throw new BuildException("File \"" + file.getAbsolutePath() + "\" does not exist or is not " + "readable.");
                }
                FileDataSource fileData = new FileDataSource(file);
                DataHandler fileDataHandler = new DataHandler((DataSource)fileData);
                body.setDataHandler(fileDataHandler);
                body.setFileName(file.getName());
                attachments.addBodyPart((BodyPart)body);
            }
            msg.setContent((Multipart)attachments);
            try {
                Transport transport = sesh.getTransport(this.SSL ? "smtps" : "smtp");
                transport.connect(this.host, this.user, this.password);
                transport.sendMessage((Message)msg, msg.getAllRecipients());
            }
            catch (SendFailedException sfe) {
                if (!this.shouldIgnoreInvalidRecipients()) {
                    throw new BuildException(GENERIC_ERROR, (Throwable)sfe);
                }
                if (sfe.getValidSentAddresses() == null || sfe.getValidSentAddresses().length == 0) {
                    throw new BuildException("Couldn't reach any recipient", (Throwable)sfe);
                }
                Address[] invalid = sfe.getInvalidAddresses();
                if (invalid == null) {
                    invalid = new Address[]{};
                }
                for (int i = 0; i < invalid.length; ++i) {
                    this.didntReach(invalid[i], "invalid", (MessagingException)((Object)sfe));
                }
                Address[] validUnsent = sfe.getValidUnsentAddresses();
                if (validUnsent == null) {
                    validUnsent = new Address[]{};
                }
                for (int i = 0; i < validUnsent.length; ++i) {
                    this.didntReach(validUnsent[i], "valid", (MessagingException)((Object)sfe));
                }
            }
        }
        catch (MessagingException e) {
            throw new BuildException(GENERIC_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException(GENERIC_ERROR, (Throwable)e);
        }
    }

    private static InternetAddress[] internetAddresses(Vector list) throws AddressException, UnsupportedEncodingException {
        int size = list.size();
        InternetAddress[] addrs = new InternetAddress[size];
        for (int i = 0; i < size; ++i) {
            EmailAddress addr = (EmailAddress)list.elementAt(i);
            String name = addr.getName();
            addrs[i] = name == null ? new InternetAddress(addr.getAddress()) : new InternetAddress(addr.getAddress(), name);
        }
        return addrs;
    }

    private String parseCharSetFromMimeType(String type) {
        if (type == null) {
            return null;
        }
        int pos = type.indexOf("charset");
        if (pos < 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(type.substring(pos), "=; ");
        token.nextToken();
        return token.nextToken();
    }

    private void didntReach(Address addr, String category, MessagingException ex) {
        String msg = "Failed to send mail to " + category + " address " + addr + " because of " + ex.getMessage();
        if (this.task != null) {
            this.task.log(msg, 1);
        } else {
            System.err.println(msg);
        }
    }

    static class SimpleAuthenticator
    extends Authenticator {
        private String user = null;
        private String password = null;

        public SimpleAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }

    class StringDataSource
    implements DataSource {
        private String data = null;
        private String type = null;
        private String charset = null;
        private ByteArrayOutputStream out;

        StringDataSource() {
        }

        public InputStream getInputStream() throws IOException {
            if (this.data == null && this.out == null) {
                throw new IOException("No data");
            }
            if (this.out != null) {
                String encodedOut = this.out.toString(this.charset);
                this.data = this.data != null ? this.data.concat(encodedOut) : encodedOut;
                this.out = null;
            }
            return new ByteArrayInputStream(this.data.getBytes(this.charset));
        }

        public OutputStream getOutputStream() throws IOException {
            this.out = this.out == null ? new ByteArrayOutputStream() : this.out;
            return this.out;
        }

        public void setContentType(String type) {
            this.type = type.toLowerCase(Locale.ENGLISH);
        }

        public String getContentType() {
            if (this.type != null && this.type.indexOf("charset") > 0 && this.type.startsWith("text/")) {
                return this.type;
            }
            return new StringBuffer(this.type != null ? this.type : "text/plain").append("; charset=").append(this.charset).toString();
        }

        public String getName() {
            return "StringDataSource";
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

