/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.IndexedValue;
import kotlin.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.Deserialization;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedType;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeCapabilitiesDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.LocalClassResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeBasedStarProjectionImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionBase;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"q\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003!!Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005A!#B\u0001\u0005\u0006\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u00031\u0001\u0011$\u0001M\u0001C[I1\u0001C\u0001\u000e\u0003a\r\u0011\u0002\u0002\u0005\u0003\u001b\ta\t\u0001\u0007\u0001\n\r!\u0015Q\u0002B\u0005\u0003\u0013\u0005A:\u0001G\u0002\n\u0007!!Q\"\u0001M\u0005#\u000e\t\u0001\"B\u0013\n\t\u0005A9\"\u0004\u0002\r\u0002a9\u0011d\u0001\u0005\r\u001b\u0005Aj!*\u0006\u0005\u0001!eQ\"\u0001M\u00053\rAQ\"D\u0001\u0019\u001cE\u001b\u0011\u0001\u0002\b&\t\u0011Y\u0001RD\u0007\u00021\u0013)C\u0002C\b\u000e\u0003a}\u0011d\u0001\u0005\u000e\u001b\u0005AZ\"\u0007\u0003\u0005\u0003!\u0001R\"\u0001M\u0011K1A\u0011#D\u0001\u0019$e!\u0001BE\u0007\u0003\u0019\u0003A\u0002\"G\u0002\t&5\t\u0001dE\u0013\b\u0011Oi\u0011\u0001\u0007\u000b\u001a\u0007!iQ\"\u0001M\u000eK%!\u0011\u0001#\u000b\u000e\u00051\u0005\u0001\u0004F\r\u0004\u0011Ui\u0011\u0001'\u0004*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001%rA!\u0011\u0005\t\f5A\u0011BA\u0005\u00021\u001bI1!\u0003\u0002\r\u0002a9\u0001DB)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!!Q\"\u0001M\u0005#\u000e\tQ\u0001A\u0015\u000e\t\rC\u0001rB\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u0007q\u0019\u0013kA\u0002\u000e\u0005\u0011E\u0001\"C\u0015\t\t\u0005C\u0001BA\u0007\u0003\u0019\u0003A\u0002!U\u0002\u0002\u000b\u0001I\u0003\u0004B!\t\u0011'i!#\u0003\t\n\u001f%1\u0011\"\u0002\t\f+\ta\t\u0001'\u0004\u0019\u000e%1\u0011\"\u0002\t\f+\ta\t\u0001\u0007\u0005\u0019\u0011aU\u0001DC)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!\u0015Q\u0002B\u0005\u0003\u0013\u0005A:\u0001G\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "", "c", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;", "parent", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeParameter;", "debugName", "", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;Ljava/util/List;Ljava/lang/String;)V", "classDescriptors", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "ownTypeParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getOwnTypeParameters", "()Ljava/util/List;", "typeParameterDescriptors", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "kotlin.jvm.PlatformType", "computeClassDescriptor", "fqNameIndex", "presentableTextForErrorType", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "presentableTextForErrorType$deserialization", "toString", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "additionalAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "typeArgument", "Lorg/jetbrains/kotlin/types/TypeProjection;", "parameter", "typeArgumentProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Argument;", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "typeParameterTypeConstructor", "typeParameterId"}, moduleName="deserialization")
public final class TypeDeserializer {
    private final Function1<? super Integer, ? extends ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, ? extends TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<? extends ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        Map $receiver = (Map)this.typeParameterDescriptors.invoke();
        return CollectionsKt.toReadOnlyList($receiver.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeCapabilitiesDeserializer flexibleTypeCapabilitiesDeserializer = this.c.getComponents().getFlexibleTypeCapabilitiesDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            FlexibleTypeCapabilities flexibleTypeCapabilities = flexibleTypeCapabilitiesDeserializer.capabilitiesById(string);
            if (flexibleTypeCapabilities == null) {
                KotlinType kotlinType = ErrorUtils.createErrorType((String)((Object)((Object)new DeserializedType(this.c, proto, null, 4, null)) + ": Capabilities not found for id " + id));
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"ErrorUtils.createErrorTy\u2026es not found for id $id\")");
                return kotlinType;
            }
            FlexibleTypeCapabilities capabilities = flexibleTypeCapabilities;
            KotlinType kotlinType = (KotlinType)new DeserializedType(this.c, proto, null, 4, null);
            ProtoBuf.Type type = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type == null) {
                Intrinsics.throwNpe();
            }
            return DelegatingFlexibleType.Companion.create(kotlinType, (KotlinType)new DeserializedType(this.c, type, null, 4, null), capabilities);
        }
        return (KotlinType)new DeserializedType(this.c, proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type, Annotations annotations2, int n) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type, annotations2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeConstructor typeConstructor(@NotNull ProtoBuf.Type proto) {
        TypeConstructor typeConstructor;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        if (proto.hasClassName()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)this.classDescriptors.invoke((Object)proto.getClassName());
            object = classDescriptor != null ? classDescriptor.getTypeConstructor() : null;
        } else if (proto.hasTypeParameter()) {
            object = this.typeParameterTypeConstructor(proto.getTypeParameter());
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v2;
            String name;
            DeclarationDescriptor container;
            block9: {
                void $receiver;
                void $receiver2;
                container = this.c.getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor = container;
                List typeParameters = declarationDescriptor instanceof ClassDescriptor ? ((ClassDescriptor)container).getTypeConstructor().getParameters() : (declarationDescriptor instanceof CallableDescriptor ? ((CallableDescriptor)container).getTypeParameters() : kotlin.CollectionsKt.emptyList());
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = typeParameters;
                void var7_6 = $receiver2;
                for (Object element : $receiver) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                    v2 = element;
                    break block9;
                }
                v2 = null;
            }
            if ((object = (parameter = (TypeParameterDescriptor)v2)) == null || (object = object.getTypeConstructor()) == null) {
                object = ErrorUtils.createErrorType((String)("Deserialized type parameter " + name + " in " + container)).getConstructor();
            }
        } else {
            object = typeConstructor = (TypeConstructor)null;
        }
        if (object == null) {
            TypeConstructor typeConstructor2 = ErrorUtils.createErrorType((String)this.presentableTextForErrorType$deserialization(proto)).getConstructor();
            typeConstructor = typeConstructor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"ErrorUtils.createErrorTy\u2026rType(proto)).constructor");
        }
        return typeConstructor;
    }

    @NotNull
    public final String presentableTextForErrorType$deserialization(@NotNull ProtoBuf.Type proto) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        if (proto.hasClassName()) {
            String string2 = this.c.getNameResolver().getClassId(proto.getClassName()).asSingleFqName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"c.nameResolver.getClassI\u2026SingleFqName().asString()");
        } else {
            string = proto.hasTypeParameter() ? "Unknown type parameter " + proto.getTypeParameter() : (proto.hasTypeParameterName() ? "Unknown type parameter " + this.c.getNameResolver().getString(proto.getTypeParameterName()) : "Unknown type");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when {\n        proto.has\u2026     \"Unknown type\"\n    }");
        return string;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Object object = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(typeParameterId);
        if (object == null || (object = object.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            object = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return object;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassResolver localClassResolver = this.c.getComponents().getLocalClassResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
            return localClassResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    @NotNull
    public final TypeProjection typeArgument(@Nullable TypeParameterDescriptor parameter, @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        Intrinsics.checkParameterIsNotNull((Object)typeArgumentProto, (String)"typeArgumentProto");
        if (Intrinsics.areEqual((Object)((Object)typeArgumentProto.getProjection()), (Object)((Object)ProtoBuf.Type.Argument.Projection.STAR))) {
            TypeProjectionBase typeProjectionBase;
            if (parameter == null) {
                KotlinType kotlinType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjectionBase = (TypeProjectionBase)new TypeBasedStarProjectionImpl(kotlinType);
            } else {
                typeProjectionBase = (TypeProjectionBase)new StarProjectionImpl(parameter);
            }
            return (TypeProjection)typeProjectionBase;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)projection), (String)"typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type == null) {
            return (TypeProjection)new TypeProjectionImpl(ErrorUtils.createErrorType((String)"No type recorded"));
        }
        ProtoBuf.Type type2 = type;
        return (TypeProjection)new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type2, null, 2));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<? extends ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, (String)"typeParameterProtos");
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        this.c = c;
        this.parent = parent;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map;
                if (TypeDeserializer.access$getTypeParameterProtos$p(this.this$0).isEmpty()) {
                    map = MapsKt.mapOf();
                } else {
                    LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                    for (IndexedValue indexedValue : kotlin.CollectionsKt.withIndex((Iterable)TypeDeserializer.access$getTypeParameterProtos$p(this.this$0))) {
                        int index = indexedValue.component1();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                        MapsKt.set((Map)result, (Object)proto.getId(), (Object)((Object)new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$p(this.this$0), proto, index)));
                    }
                    map = result;
                }
                return map;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List<ProtoBuf.TypeParameter> access$getTypeParameterProtos$p(TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }
}

