/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0001\u0013C\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002u\u0005\t\")\u0002R\u0007\u0005A\u0019!J\u000b\u0005\u0017!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002\u001a\u000b!\u001dQb\u0001\r\u0005S\u0005AJ!G\u0002\t\u000b5\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001G\u0001&\u001d\u0011Y\u0001RB\u0007\u00021\u001dIR\u0001c\u0002\u000e\u0007a!\u0011&\u0001M\u00053\rAy!D\u0001\u0019\u0011\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion"}, moduleName="intellij-markdown")
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final String WHSP = "[ \\t]*";
    @NotNull
    public static final Function1<? super String, ? extends String> NOT_CHARS;
    @NotNull
    public static final String LINK_LABEL;
    @NotNull
    public static final String NONCONTROL = "(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])";
    @NotNull
    public static final String LINK_DESTINATION = "(?:<(?:\\\\[<>]|[^<>])*>|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\((?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\)(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])+)";
    @NotNull
    public static final String LINK_TITLE;
    @NotNull
    public static final String NO_MORE_ONE_NEWLINE = "[ \\t]*(?:\\n[ \\t]*)?";
    @NotNull
    public static final Regex LINK_DEFINITION_REGEX;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE;
        WHSP = WHSP;
        NOT_CHARS = Companion.NOT_CHARS.1.INSTANCE;
        LINK_LABEL = "\\" + "[" + (String)Companion.getNOT_CHARS().invoke((Object)"\\[\\]") + "\\" + "]";
        NONCONTROL = NONCONTROL;
        LINK_DESTINATION = "(?:<(?:" + "\\" + "\\" + "[<>]|[^<>])*>|" + Companion.getNONCONTROL() + "*" + "\\" + "(" + Companion.getNONCONTROL() + "*" + "\\" + ")" + Companion.getNONCONTROL() + "*|" + Companion.getNONCONTROL() + "+)";
        LINK_TITLE = "(?:" + "\"" + (String)Companion.getNOT_CHARS().invoke((Object)"\"") + "\"" + "|'" + (String)Companion.getNOT_CHARS().invoke((Object)"'") + "'|" + "\\" + "(" + (String)Companion.getNOT_CHARS().invoke((Object)"\\)") + "\\" + "))";
        NO_MORE_ONE_NEWLINE = NO_MORE_ONE_NEWLINE;
        LINK_DEFINITION_REGEX = new Regex("^ {0,3}(" + Companion.getLINK_LABEL() + "):" + (Companion.getNO_MORE_ONE_NEWLINE() + "(" + Companion.getLINK_DESTINATION() + ")") + ("(?:" + Companion.getNO_MORE_ONE_NEWLINE() + "(" + Companion.getLINK_TITLE() + ")" + Companion.getWHSP() + "(?:" + "\\" + "n|" + "$" + "))?"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        void furthestOffset;
        int matchLength;
        LookaheadText.Position endPosition;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        MatchResult matchResult = Regex.find$default((Regex)Companion.getLINK_DEFINITION_REGEX(), (CharSequence)pos.getTextFromPosition(), (int)0, (int)2);
        if (matchResult == null) {
            return CollectionsKt.emptyList();
        }
        MatchResult matchResult2 = matchResult;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        int n = 1;
        int n2 = matchResult2.getGroups().size() - 1;
        if (n <= n2) {
            while (true) {
                Unit unit;
                void i;
                if (matchResult2.getGroups().get((int)i) != null) {
                    IElementType iElementType;
                    void $receiver;
                    MatchGroup group = (MatchGroup)$receiver;
                    IntRange intRange = Companion.addToRangeAndWiden(group.getRange(), pos.getOffset());
                    switch (i) {
                        case 1: {
                            iElementType = MarkdownElementTypes.Companion.getLINK_LABEL();
                            break;
                        }
                        case 2: {
                            iElementType = MarkdownElementTypes.Companion.getLINK_DESTINATION();
                            break;
                        }
                        case 3: {
                            iElementType = MarkdownElementTypes.Companion.getLINK_TITLE();
                            break;
                        }
                        default: {
                            throw (Throwable)((Object)new AssertionError((Object)"There are no more than three groups in this regex"));
                        }
                    }
                    productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(intRange, iElementType)));
                    furthestOffset.element = ((Number)group.getRange().getEndInclusive()).intValue();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if ((endPosition = pos.nextPosition(matchLength = furthestOffset.element - ((Number)matchResult2.getRange().getStart()).intValue() + 1)) != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!B\u0001\u0005\n\u0015\tA\"A\u0003\u0002\t\u000f)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0017!eQ\"\u0001\r\u000e3\rAY\"D\u0001\u0019\u001be\u0019\u0001BD\u0007\u00021;)\u0013\u0002C\b\u000e\u0003a}\u0011$\u0002\u0005\u0011\u001b\rA\n#K\u0001\u0019#%ZAa\u0011\u0005\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1!k\u0006\u0005\u0007\"\u000b\u0001rA\u0007\u00021\u0011\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0003\t\u000b%ZAa\u0011\u0005\t\f5\t\u0001\u0004B)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u0019AQ!K\u0006\u0005\u0007\"Ai!D\u0001\u0019\tE\u001bQ!B\u0001\r\u00025\u0011Aa\u0002\u0005\u0006S/!1\tS\u0001\t\u00105\t\u0001\u0004B)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t!AQ!K\t\u0005\u0007\"A\t\"D\u0004\n\u0005%\t\u0001\u0004B\u0005\u0003\u0013\u0005AB\u0001G\u0005R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011M\u0001BCU\f\t\rC\u0015\u0001#\u0006\u000e\u0003a!\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\f\u0011\u0015I;\u0002B\"I\u0003!]Q\"\u0001\r\u0005#\u000e)Q!\u0001G\u0001\u001b\t!A\u0002C\u0003"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "()V", "LINK_DEFINITION_REGEX", "Lkotlin/text/Regex;", "getLINK_DEFINITION_REGEX", "()Lkotlin/text/Regex;", "LINK_DESTINATION", "", "getLINK_DESTINATION", "()Ljava/lang/String;", "LINK_LABEL", "getLINK_LABEL", "LINK_TITLE", "getLINK_TITLE", "NONCONTROL", "getNONCONTROL", "NOT_CHARS", "Lkotlin/Function1;", "getNOT_CHARS", "()Lkotlin/jvm/functions/Function1;", "NO_MORE_ONE_NEWLINE", "getNO_MORE_ONE_NEWLINE", "WHSP", "getWHSP", "addToRangeAndWiden", "Lkotlin/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getWHSP() {
            return WHSP;
        }

        @NotNull
        public final Function1<String, String> getNOT_CHARS() {
            return NOT_CHARS;
        }

        @NotNull
        public final String getLINK_LABEL() {
            return LINK_LABEL;
        }

        @NotNull
        public final String getNONCONTROL() {
            return NONCONTROL;
        }

        @NotNull
        public final String getLINK_DESTINATION() {
            return LINK_DESTINATION;
        }

        @NotNull
        public final String getLINK_TITLE() {
            return LINK_TITLE;
        }

        @NotNull
        public final String getNO_MORE_ONE_NEWLINE() {
            return NO_MORE_ONE_NEWLINE;
        }

        @NotNull
        public final Regex getLINK_DEFINITION_REGEX() {
            return LINK_DEFINITION_REGEX;
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return new IntRange(((Number)range.getStart()).intValue() + t, ((Number)range.getEndInclusive()).intValue() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

