/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\r\u0001A\r\u0011$\u0001M\u0001;\u0003\r\u0011UA)\u0004\u0003!\t\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil;", "", "()V", "Companion"}, moduleName="intellij-markdown")
public final class LinkParserUtil {
    public static final Companion Companion = org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil$Companion.INSTANCE;

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\b\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005A\t#B\u0001\t\t\u0015\tA!\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)3\u0003c\u0001\u000e\t1\u0005\u0001DA\u0015\u00021\u000bIb\u0001C\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00051\u000fIR\u0001#\u0003\u000e\u0007a\u0011\u0011&\u0001M\u0003KiAQ!\u0004\u0003\r\u0002a\u0011\u0011&\u0001M\u00033\u0019A1!\u0004\u0003\n\u0005%\t\u0001\u0004\u0002M\u00043\u0019AY!\u0004\u0003\n\u0005%\t\u0001T\u0002\r\u00073\u0015AI!D\u0002\u0019\u0005%\n\u0001TA\u0013\u001b\u0011\u001diA\u0001$\u0001\u0019\u0005%\n\u0001TA\r\u0007\u0011\riA!\u0003\u0002\n\u0003a!\u0001tA\r\u0007\u0011\u0017iA!\u0003\u0002\n\u0003a5\u0001DB\r\u0006\u0011\u0013i1\u0001\u0007\u0002*\u0003a\u0015Qe\u0005E\b\u001b\u0011a\t\u0001\u0007\u0002*\u0003a\u0015\u0011D\u0002\u0005\u0004\u001b\u0011I!!C\u0001\u0019\ta\u001d\u0011$\u0002E\u0005\u001b\rA\"!K\u0001\u0019\u0006\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil$Companion;", "", "()V", "parseLinkDestination", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "result", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "iterator", "parseLinkLabel", "delegateIndices", "", "", "parseLinkText", "parseLinkTitle"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @Nullable
        public final TokensCache.Iterator parseLinkDestination(@NotNull Collection<SequentialParser.Node> result, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getEOL()) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRPAREN())) {
                return null;
            }
            int startIndex = it.getIndex();
            boolean withBraces = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLT());
            if (withBraces) {
                it = it.advance();
            }
            boolean hasOpenedParentheses = false;
            while (!(it.getType() == null || withBraces && Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getGT()))) {
                if (!withBraces) {
                    if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLPAREN())) {
                        if (hasOpenedParentheses) break;
                        hasOpenedParentheses = true;
                    }
                    IElementType next = it.rawLookup(1);
                    if (SequentialParserUtil.Companion.isWhitespace(it, 1) || next == null) break;
                    if (Intrinsics.areEqual((Object)next, (Object)MarkdownTokenTypes.Companion.getRPAREN())) {
                        if (!hasOpenedParentheses) break;
                        hasOpenedParentheses = false;
                    }
                }
                it = it.advance();
            }
            if (it.getType() != null && !hasOpenedParentheses) {
                result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getLINK_DESTINATION()));
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkLabel(@NotNull Collection<SequentialParser.Node> result, @NotNull List<Integer> delegateIndices, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull(delegateIndices, (String)"delegateIndices");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET()) ^ true) {
                return null;
            }
            int startIndex = it.getIndex();
            ArrayList<Integer> indicesToDelegate = new ArrayList<Integer>();
            it = it.advance();
            while (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET()) ^ true && it.getType() != null) {
                indicesToDelegate.add(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET())) break;
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET())) {
                int endIndex = it.getIndex();
                if (endIndex == startIndex + 1) {
                    return null;
                }
                result.add(new SequentialParser.Node(new IntRange(startIndex, endIndex + 1), MarkdownElementTypes.Companion.getLINK_LABEL()));
                delegateIndices.addAll((Collection<Integer>)indicesToDelegate);
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkText(@NotNull Collection<SequentialParser.Node> result, @NotNull List<Integer> delegateIndices, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull(delegateIndices, (String)"delegateIndices");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET()) ^ true) {
                return null;
            }
            int startIndex = it.getIndex();
            ArrayList<Integer> indicesToDelegate = new ArrayList<Integer>();
            int bracketDepth = 1;
            it = it.advance();
            while (!(it.getType() == null || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET()) && --bracketDepth == 0)) {
                indicesToDelegate.add(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET())) {
                    ++bracketDepth;
                }
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET())) {
                result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getLINK_TEXT()));
                delegateIndices.addAll((Collection<Integer>)indicesToDelegate);
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkTitle(@NotNull Collection<SequentialParser.Node> result, @NotNull TokensCache.Iterator iterator) {
            IElementType closingType;
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                return null;
            }
            int startIndex = it.getIndex();
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getSINGLE_QUOTE()) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getDOUBLE_QUOTE())) {
                closingType = it.getType();
            } else if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLPAREN())) {
                closingType = MarkdownTokenTypes.Companion.getRPAREN();
            } else {
                return null;
            }
            it = it.advance();
            while (it.getType() != null && Intrinsics.areEqual((Object)it.getType(), (Object)closingType) ^ true) {
                it = it.advance();
            }
            if (it.getType() != null) {
                result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getLINK_TITLE()));
                return it;
            }
            return null;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

