/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u001f\u0015\tA\"A\u0003\u0001\u0019\u0001\u0001R!G\u0001\u0019\u0002u\u0005Q!)\u0002R\u0007\u0005A\u0011!J\b\u0005\u0017!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e1\u0001rA\u0007\u0005\u0013\tI\u0011\u0001'\u0003\u0019\t\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/IntRange;", "Companion"}, moduleName="intellij-markdown")
public final class ReferenceLinkParser
implements SequentialParser {
    public static final Companion Companion = org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser$Companion.INSTANCE;

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<? extends IntRange> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResult result = new SequentialParser.ParsingResult();
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        TokensCache.Iterator iterator = tokens.new TokensCache.ListIterator(indices, 0);
        while (iterator.getType() != null) {
            ArrayList localDelegates;
            ArrayList resultNodes;
            TokensCache.Iterator afterLink;
            if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET()) && (afterLink = Companion.parseReferenceLink(resultNodes = new ArrayList(), localDelegates = new ArrayList(), iterator)) != null) {
                iterator = afterLink.advance();
                result = result.withNodes(resultNodes).withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges(localDelegates));
                continue;
            }
            delegateIndices.add(iterator.getIndex());
            iterator = iterator.advance();
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<? extends Integer>)delegateIndices));
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\b\u0006\u00031\tQ\u0001A\u0003\u0002\u0011C)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\u0015Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002Km!\u0011\u0001c\u0001\u000e\t1\u0005\u0001DA\u0015\u00021\u000bIb\u0001C\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00051\u000fIb\u0001#\u0003\u000e\t%\u0011\u0011\"\u0001M\u00061\u0015IR\u0001\u0003\u0004\u000e\u0007a\u0011\u0011&\u0001M\u0003KiAi!\u0004\u0003\r\u0002a\u0011\u0011&\u0001M\u00033\u0019Aq!\u0004\u0003\n\u0005%\t\u0001\u0004\u0002M\u00043\u0019Ay!\u0004\u0003\n\u0005%\t\u00014\u0002\r\u00063\u0015Aa!D\u0002\u0019\u0005%\n\u0001TA\u0013\u001c\t\u0005A\u0001\"\u0004\u0003\r\u0002a\u0011\u0011&\u0001M\u00033\u0019A1!\u0004\u0003\n\u0005%\t\u0001\u0004\u0002M\u00043\u0019AI!\u0004\u0003\n\u0005%\t\u00014\u0002\r\u00063\u0015Aa!D\u0002\u0019\u0005%\n\u0001T\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser$Companion;", "", "()V", "parseFullReferenceLink", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "result", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "delegateIndices", "", "", "iterator", "parseReferenceLink", "resultNodes", "localDelegates", "parseShortReferenceLink"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @Nullable
        public final TokensCache.Iterator parseReferenceLink(@NotNull Collection<SequentialParser.Node> resultNodes, @NotNull List<Integer> localDelegates, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(resultNodes, (String)"resultNodes");
            Intrinsics.checkParameterIsNotNull(localDelegates, (String)"localDelegates");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator result = this.parseFullReferenceLink(resultNodes, localDelegates, iterator);
            if (result != null) {
                return result;
            }
            resultNodes.clear();
            localDelegates.clear();
            result = this.parseShortReferenceLink(resultNodes, localDelegates, iterator);
            if (result != null) {
                return result;
            }
            return null;
        }

        private final TokensCache.Iterator parseFullReferenceLink(Collection<SequentialParser.Node> result, List<Integer> delegateIndices, TokensCache.Iterator iterator) {
            TokensCache.Iterator it;
            int startIndex = iterator.getIndex();
            TokensCache.Iterator iterator2 = it = iterator;
            if (iterator2 == null) {
                Intrinsics.throwNpe();
            }
            if ((it = LinkParserUtil.Companion.parseLinkText(result, delegateIndices, iterator2)) == null) {
                return null;
            }
            if (Intrinsics.areEqual((Object)(it = it.advance()).getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                it = it.advance();
            }
            if ((it = LinkParserUtil.Companion.parseLinkLabel(result, delegateIndices, it)) == null) {
                return null;
            }
            result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getFULL_REFERENCE_LINK()));
            return it;
        }

        private final TokensCache.Iterator parseShortReferenceLink(Collection<SequentialParser.Node> result, List<Integer> delegateIndices, TokensCache.Iterator iterator) {
            TokensCache.Iterator it;
            int startIndex = iterator.getIndex();
            TokensCache.Iterator iterator2 = it = iterator;
            if (iterator2 == null) {
                Intrinsics.throwNpe();
            }
            if ((it = LinkParserUtil.Companion.parseLinkLabel(result, delegateIndices, iterator2)) == null) {
                return null;
            }
            TokensCache.Iterator shortcutLinkEnd = it;
            if (Intrinsics.areEqual((Object)(it = it.advance()).getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                it = it.advance();
            }
            it = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET()) && Intrinsics.areEqual((Object)it.rawLookup(1), (Object)MarkdownTokenTypes.Companion.getRBRACKET()) ? it.advance() : shortcutLinkEnd;
            result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getSHORT_REFERENCE_LINK()));
            return it;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

