/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayInitializer;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Catch;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StringLiteral;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SupportAnnotationDetector
extends Detector
implements Detector.JavaScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(SupportAnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RANGE = Issue.create("Range", "Outside Range", "Some parameters are required to in a particular numerical range; this check makes sure that arguments passed fall within the range. For arrays, Strings and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue RESOURCE_TYPE = Issue.create("ResourceType", "Wrong Resource Type", "Ensures that resource id's passed to APIs are of the right type; for example, calling `Resources.getColor(R.string.name)` is wrong.", Category.CORRECTNESS, 7, Severity.FATAL, IMPLEMENTATION);
    public static final Issue COLOR_USAGE = Issue.create("ResourceAsColor", "Should pass resolved color instead of resource id", "Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", Category.CORRECTNESS, 7, Severity.ERROR, IMPLEMENTATION);
    public static final Issue TYPE_DEF = Issue.create("WrongConstant", "Incorrect constant", "Ensures that when parameter in a method only allows a specific set of constants, calls obey those rules.", Category.SECURITY, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue CHECK_RESULT = Issue.create("CheckResult", "Ignoring results", "Some methods have no side effects, an calling them without doing something without the result is suspicious. ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue CHECK_PERMISSION = Issue.create("UseCheckPermission", "Using the result of check permission calls", "You normally want to use the result of checking a permission; these methods return whether the permission is held; they do not throw an error if the permission is not granted. Code which does not do anything with the return value probably meant to be calling the enforce methods instead, e.g. rather than `Context#checkCallingPermission` it should call `Context#enforceCallingPermission`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue MISSING_PERMISSION = Issue.create("MissingPermission", "Missing Permissions", "This check scans through your code and libraries and looks at the APIs being used, and checks this against the set of permissions required to access those APIs. If the code using those APIs is called at runtime, then the program will crash.\n\nFurthermore, for permissions that are revocable (with targetSdkVersion 23), client code must also be prepared to handle the calls throwing an exception if the user rejects the request for permission at runtime.", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
    public static final Issue THREAD = Issue.create("WrongThread", "Wrong Thread", "Ensures that a method which expects to be called on a specific thread, is actually called from that thread. For example, calls on methods in widgets should always be made on the UI thread.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/components/processes-and-threads.html#Threads");
    public static final String CHECK_RESULT_ANNOTATION = "android.support.annotation.CheckResult";
    public static final String COLOR_INT_ANNOTATION = "android.support.annotation.ColorInt";
    public static final String INT_RANGE_ANNOTATION = "android.support.annotation.IntRange";
    public static final String FLOAT_RANGE_ANNOTATION = "android.support.annotation.FloatRange";
    public static final String SIZE_ANNOTATION = "android.support.annotation.Size";
    public static final String PERMISSION_ANNOTATION = "android.support.annotation.RequiresPermission";
    public static final String UI_THREAD_ANNOTATION = "android.support.annotation.UiThread";
    public static final String MAIN_THREAD_ANNOTATION = "android.support.annotation.MainThread";
    public static final String WORKER_THREAD_ANNOTATION = "android.support.annotation.WorkerThread";
    public static final String BINDER_THREAD_ANNOTATION = "android.support.annotation.BinderThread";
    public static final String RES_SUFFIX = "Res";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final ResourceType COLOR_INT_MARKER_TYPE = ResourceType.PUBLIC;
    private PermissionHolder mPermissions;

    private void checkMethodAnnotation(@NonNull JavaContext context, @NonNull JavaParser.ResolvedMethod method, @NonNull MethodInvocation node, @NonNull JavaParser.ResolvedAnnotation annotation) {
        String signature = annotation.getSignature();
        if (CHECK_RESULT_ANNOTATION.equals(signature) || signature.endsWith(".CheckReturnValue")) {
            SupportAnnotationDetector.checkResult(context, node, annotation);
        } else if (signature.equals(PERMISSION_ANNOTATION)) {
            this.checkPermission(context, node, method, annotation);
        } else if (signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.")) {
            SupportAnnotationDetector.checkThreading(context, node, method, signature);
        }
    }

    private static void checkParameterAnnotation(@NonNull JavaContext context, @NonNull Node argument, @NonNull JavaParser.ResolvedAnnotation annotation) {
        String signature = annotation.getSignature();
        if (COLOR_INT_ANNOTATION.equals(signature)) {
            SupportAnnotationDetector.checkColor(context, argument);
        } else if (signature.equals(INT_RANGE_ANNOTATION)) {
            SupportAnnotationDetector.checkIntRange(context, annotation, argument);
        } else if (signature.equals(FLOAT_RANGE_ANNOTATION)) {
            SupportAnnotationDetector.checkFloatRange(context, annotation, argument);
        } else if (signature.equals(SIZE_ANNOTATION)) {
            SupportAnnotationDetector.checkSize(context, annotation, argument);
        } else if (signature.equals("android.support.annotation.IntDef")) {
            boolean flag = annotation.getValue("flag") == Boolean.TRUE;
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, flag);
        } else if (signature.equals("android.support.annotation.StringDef")) {
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, false);
        } else if (signature.endsWith(RES_SUFFIX)) {
            String typeString = signature.substring("android.support.annotation.".length(), signature.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
            ResourceType type = ResourceType.getEnum((String)typeString);
            if (type != null) {
                SupportAnnotationDetector.checkResourceType(context, argument, type);
            } else if (typeString.equals("any")) {
                SupportAnnotationDetector.checkResourceType(context, argument, null);
            }
        }
    }

    private static void checkColor(@NonNull JavaContext context, @NonNull Node argument) {
        if (argument instanceof InlineIfExpression) {
            InlineIfExpression expression = (InlineIfExpression)argument;
            SupportAnnotationDetector.checkColor(context, (Node)expression.astIfTrue());
            SupportAnnotationDetector.checkColor(context, (Node)expression.astIfFalse());
            return;
        }
        List<ResourceType> types = SupportAnnotationDetector.getResourceTypes(context, argument);
        if (types != null && types.contains(ResourceType.COLOR)) {
            String message = String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.toString());
            context.report(COLOR_USAGE, argument, context.getLocation(argument), message);
        }
    }

    private void checkPermission(@NonNull JavaContext context, @NonNull MethodInvocation node, @NonNull JavaParser.ResolvedMethod method, @NonNull JavaParser.ResolvedAnnotation annotation) {
        PermissionRequirement requirement = PermissionRequirement.create(context, annotation);
        if (requirement.isConditional()) {
            return;
        }
        PermissionHolder permissions = this.getPermissions(context);
        if (!requirement.isSatisfied(permissions)) {
            if (!requirement.isSatisfied(permissions = SupportAnnotationDetector.addLocalPermissions(context, permissions, (Node)node))) {
                String name = method.getContainingClass().getSimpleName() + "." + method.getName();
                String message = SupportAnnotationDetector.getMissingPermissionMessage(requirement, name, permissions);
                context.report(MISSING_PERMISSION, (Node)node, context.getLocation((Node)node), message);
            }
        } else if (requirement.isRevocable(permissions) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            Node methodNode;
            MethodDeclaration declaration;
            Try tryCatch;
            boolean handlesMissingPermission = false;
            MethodInvocation parent = node;
            while ((tryCatch = JavaContext.getParentOfType((Node)parent, Try.class)) != null) {
                for (Catch aCatch : tryCatch.astCatches()) {
                    TypeReference catchType = aCatch.astExceptionDeclaration().astTypeReference();
                    if (!SupportAnnotationDetector.isSecurityException(context, catchType)) continue;
                    handlesMissingPermission = true;
                    break;
                }
                parent = tryCatch;
            }
            if (!handlesMissingPermission && (declaration = JavaContext.getParentOfType((Node)parent, MethodDeclaration.class)) != null) {
                for (TypeReference typeReference : declaration.astThrownTypeReferences()) {
                    if (!SupportAnnotationDetector.isSecurityException(context, typeReference)) continue;
                    handlesMissingPermission = true;
                    break;
                }
            }
            if (!handlesMissingPermission && (methodNode = JavaContext.findSurroundingMethod((Node)node)) != null) {
                CheckPermissionVisitor visitor = new CheckPermissionVisitor((Node)node);
                methodNode.accept((AstVisitor)visitor);
                handlesMissingPermission = visitor.checksPermission();
            }
            if (!handlesMissingPermission) {
                String message = SupportAnnotationDetector.getUnhandledPermissionMessage();
                context.report(MISSING_PERMISSION, (Node)node, context.getLocation((Node)node), message);
            }
        }
    }

    @NonNull
    private static PermissionHolder addLocalPermissions(@NonNull JavaContext context, @NonNull PermissionHolder permissions, @NonNull Node node) {
        Node methodNode = JavaContext.findSurroundingMethod(node);
        if (methodNode == null) {
            return permissions;
        }
        JavaParser.ResolvedNode resolved = context.resolve(methodNode);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return permissions;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        JavaParser.ResolvedAnnotation annotation = method.getAnnotation(PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        annotation = method.getContainingClass().getAnnotation(PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        return permissions;
    }

    @NonNull
    private static PermissionHolder mergeAnnotationPermissions(@NonNull JavaContext context, @NonNull PermissionHolder permissions, @Nullable JavaParser.ResolvedAnnotation annotation) {
        if (annotation != null) {
            PermissionRequirement requirement = PermissionRequirement.create(context, annotation);
            permissions = PermissionHolder.SetPermissionLookup.join(permissions, requirement);
        }
        return permissions;
    }

    public static String getMissingPermissionMessage(@NonNull PermissionRequirement requirement, @NonNull String callName, @NonNull PermissionHolder permissions) {
        return String.format("Missing permissions required by %1$s: %2$s", callName, requirement.describeMissingPermissions(permissions));
    }

    public static String getUnhandledPermissionMessage() {
        return "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or handle a potential `SecurityException`";
    }

    private static boolean isSecurityException(@NonNull JavaContext context, @NonNull TypeReference typeReference) {
        JavaParser.TypeDescriptor type = context.getType((Node)typeReference);
        return type != null && (type.matchesSignature("java.lang.SecurityException") || type.matchesSignature("java.lang.RuntimeException") || type.matchesSignature("java.lang.Exception") || type.matchesSignature("java.lang.Throwable"));
    }

    private PermissionHolder getPermissions(@NonNull JavaContext context) {
        if (this.mPermissions == null) {
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
            LintClient client = context.getClient();
            Project mainProject = context.getMainProject();
            for (File manifest : mainProject.getManifestFiles()) {
                SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
            }
            for (Project library : mainProject.getAllLibraries()) {
                for (File manifest : library.getManifestFiles()) {
                    SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
                }
            }
            this.mPermissions = new PermissionHolder.SetPermissionLookup(permissions, revocable);
        }
        return this.mPermissions;
    }

    private static void addPermissions(@NonNull LintClient client, @NonNull Set<String> permissions, @NonNull Set<String> revocable, @NonNull File manifest) {
        Document document = XmlUtils.parseDocumentSilently((String)client.readFile(manifest), (boolean)true);
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList children = root.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String name;
            String protectionLevel;
            Element element;
            org.w3c.dom.Node item = children.item(i);
            if (item.getNodeType() != 1) continue;
            String nodeName = item.getNodeName();
            if (nodeName.equals("uses-permission")) {
                element = (Element)item;
                String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (name2.isEmpty()) continue;
                permissions.add(name2);
                continue;
            }
            if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)item).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
            revocable.add(name);
        }
    }

    private static void checkResult(@NonNull JavaContext context, @NonNull MethodInvocation node, @NonNull JavaParser.ResolvedAnnotation annotation) {
        if (node.getParent() instanceof ExpressionStatement) {
            String methodName = node.astName().astValue();
            Object suggested = annotation.getValue(ATTR_SUGGEST);
            Issue issue = CHECK_RESULT;
            if (methodName.startsWith("check") && methodName.contains("Permission")) {
                issue = CHECK_PERMISSION;
            }
            String message = String.format("The result of `%1$s` is not used", methodName);
            if (suggested != null) {
                message = String.format("The result of `%1$s` is not used; did you mean to call `%2$s`?", methodName, suggested.toString());
            }
            context.report(issue, (Node)node, context.getLocation((Node)node), message);
        }
    }

    private static void checkThreading(@NonNull JavaContext context, @NonNull MethodInvocation node, @NonNull JavaParser.ResolvedMethod method, @NonNull String annotation) {
        String threadContext = SupportAnnotationDetector.getThreadContext(context, node);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread(threadContext, annotation)) {
            String message = String.format("Method %1$s must be called from the `%2$s` thread, currently inferred thread is `%3$s` thread", method.getName(), SupportAnnotationDetector.describeThread(annotation), SupportAnnotationDetector.describeThread(threadContext));
            context.report(THREAD, (Node)node, context.getLocation((Node)node), message);
        }
    }

    @NonNull
    public static String describeThread(@NonNull String annotation) {
        if (UI_THREAD_ANNOTATION.equals(annotation)) {
            return "UI";
        }
        if (MAIN_THREAD_ANNOTATION.equals(annotation)) {
            return "main";
        }
        if (BINDER_THREAD_ANNOTATION.equals(annotation)) {
            return "binder";
        }
        if (WORKER_THREAD_ANNOTATION.equals(annotation)) {
            return "worker";
        }
        return "other";
    }

    public static boolean isCompatibleThread(@NonNull String thread1, @NonNull String thread2) {
        if (thread1.equals(thread2)) {
            return true;
        }
        return thread1.equals(UI_THREAD_ANNOTATION) ? thread2.equals(MAIN_THREAD_ANNOTATION) : thread1.equals(MAIN_THREAD_ANNOTATION) && thread2.equals(UI_THREAD_ANNOTATION);
    }

    @Nullable
    private static String getThreadContext(@NonNull JavaContext context, @NonNull MethodInvocation methodCall) {
        JavaParser.ResolvedNode resolved;
        Node node = JavaContext.findSurroundingMethod((Node)methodCall);
        if (node != null && (resolved = context.resolve(node)) instanceof JavaParser.ResolvedMethod) {
            String name;
            JavaParser.ResolvedMethod method;
            JavaParser.ResolvedClass cls = method.getContainingClass();
            for (method = (JavaParser.ResolvedMethod)resolved; method != null; method = method.getSuperMethod()) {
                for (JavaParser.ResolvedAnnotation annotation : method.getAnnotations()) {
                    name = annotation.getSignature();
                    if (!name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                    return name;
                }
            }
            while (cls != null) {
                for (JavaParser.ResolvedAnnotation annotation : cls.getAnnotations()) {
                    name = annotation.getSignature();
                    if (!name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                    return name;
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private static boolean isNumber(@NonNull Node argument) {
        return argument instanceof IntegralLiteral || argument instanceof UnaryExpression && ((UnaryExpression)argument).astOperator() == UnaryOperator.UNARY_MINUS && ((UnaryExpression)argument).astOperand() instanceof IntegralLiteral;
    }

    private static boolean isZero(@NonNull Node argument) {
        return argument instanceof IntegralLiteral && ((IntegralLiteral)argument).astIntValue() == 0;
    }

    private static boolean isMinusOne(@NonNull Node argument) {
        return argument instanceof UnaryExpression && ((UnaryExpression)argument).astOperator() == UnaryOperator.UNARY_MINUS && ((UnaryExpression)argument).astOperand() instanceof IntegralLiteral && ((IntegralLiteral)((UnaryExpression)argument).astOperand()).astIntValue() == 1;
    }

    private static void checkResourceType(@NonNull JavaContext context, @NonNull Node argument, @Nullable ResourceType expectedType) {
        List<ResourceType> actual = SupportAnnotationDetector.getResourceTypes(context, argument);
        if (actual == null && (!SupportAnnotationDetector.isNumber(argument) || SupportAnnotationDetector.isZero(argument) || SupportAnnotationDetector.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (expectedType == null || actual.contains(expectedType) || expectedType == ResourceType.DRAWABLE && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        String message = actual != null && actual.size() == 1 && actual.get(0) == COLOR_INT_MARKER_TYPE ? "Expected a color resource id (`R.color.`) but received an RGB integer" : (expectedType == COLOR_INT_MARKER_TYPE ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.toString()) : (expectedType != null ? String.format("Expected resource of type %1$s", expectedType.getName()) : "Expected resource identifier (`R`.type.`name`)"));
        context.report(RESOURCE_TYPE, argument, context.getLocation(argument), message);
    }

    @Nullable
    private static List<ResourceType> getResourceTypes(@NonNull JavaContext context, @NonNull Node argument) {
        block14: {
            JavaParser.ResolvedNode resolved;
            block15: {
                block13: {
                    Select select;
                    Expression typeOperand;
                    Node grandParent;
                    Node parent;
                    if (!(argument instanceof Select)) break block13;
                    Select node = (Select)argument;
                    if (node.astOperand() instanceof Select) {
                        VariableReference reference;
                        Select innerSelect;
                        Select select2 = (Select)node.astOperand();
                        if (select2.astOperand() instanceof Select && (innerSelect = (Select)select2.astOperand()).astIdentifier().astValue().equals("R")) {
                            String typeName = select2.astIdentifier().astValue();
                            ResourceType type = ResourceType.getEnum((String)typeName);
                            return type != null ? Collections.singletonList(type) : null;
                        }
                        if (select2.astOperand() instanceof VariableReference && (reference = (VariableReference)select2.astOperand()).astIdentifier().astValue().equals("R")) {
                            String typeName = select2.astIdentifier().astValue();
                            ResourceType type = ResourceType.getEnum((String)typeName);
                            return type != null ? Collections.singletonList(type) : null;
                        }
                    }
                    if (node.astIdentifier().astValue().equals("R") && (parent = node.getParent()) instanceof Select && (grandParent = parent.getParent()) instanceof Select && (typeOperand = (select = (Select)grandParent).astOperand()) instanceof Select) {
                        Select typeSelect = (Select)typeOperand;
                        String typeName = typeSelect.astIdentifier().astValue();
                        ResourceType type = ResourceType.getEnum((String)typeName);
                        return type != null ? Collections.singletonList(type) : null;
                    }
                    break block14;
                }
                if (!(argument instanceof VariableReference)) break block15;
                Statement statement = JavaContext.getParentOfType(argument, Statement.class, false);
                if (statement == null) break block14;
                ListIterator iterator = statement.getParent().getChildren().listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != statement) continue;
                    if (!iterator.hasPrevious()) break;
                    iterator.previous();
                    break;
                }
                String targetName = ((VariableReference)argument).astIdentifier().astValue();
                while (iterator.hasPrevious()) {
                    BinaryExpression binaryExpression;
                    ExpressionStatement expressionStatement;
                    Expression expression;
                    Node previous = (Node)iterator.previous();
                    if (previous instanceof VariableDeclaration) {
                        VariableDeclaration declaration = (VariableDeclaration)previous;
                        VariableDefinition definition = declaration.astDefinition();
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                            return SupportAnnotationDetector.getResourceTypes(context, (Node)entry.astInitializer());
                        }
                        continue;
                    }
                    if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
                    return SupportAnnotationDetector.getResourceTypes(context, (Node)binaryExpression.astRight());
                }
                break block14;
            }
            if (argument instanceof MethodInvocation && (resolved = context.resolve(argument)) != null) {
                for (JavaParser.ResolvedAnnotation annotation : resolved.getAnnotations()) {
                    String signature = annotation.getSignature();
                    if (signature.equals(COLOR_INT_ANNOTATION)) {
                        return Collections.singletonList(COLOR_INT_MARKER_TYPE);
                    }
                    if (!signature.endsWith(RES_SUFFIX) || !signature.startsWith("android.support.annotation.")) continue;
                    String typeString = signature.substring("android.support.annotation.".length(), signature.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
                    ResourceType type = ResourceType.getEnum((String)typeString);
                    if (type != null) {
                        return Collections.singletonList(type);
                    }
                    if (!typeString.equals("any")) continue;
                    ResourceType[] types = ResourceType.values();
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)types.length);
                    for (ResourceType t : types) {
                        if (t == COLOR_INT_MARKER_TYPE) continue;
                        result.add(t);
                    }
                    return result;
                }
            }
        }
        return null;
    }

    private static void checkIntRange(@NonNull JavaContext context, @NonNull JavaParser.ResolvedAnnotation annotation, @NonNull Node argument) {
        long to;
        long from;
        Object object = ConstantEvaluator.evaluate(context, argument);
        if (!(object instanceof Number)) {
            return;
        }
        long value = ((Number)object).longValue();
        String message = SupportAnnotationDetector.getIntRangeError(value, from = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_FROM, Long.MIN_VALUE), to = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_TO, Long.MAX_VALUE));
        if (message != null) {
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getIntRangeError(long value, long from, long to) {
        String message = null;
        if (value < from || value > to) {
            StringBuilder sb = new StringBuilder(20);
            if (value < from) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(from));
            } else {
                assert (value > to);
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(to));
            }
            sb.append(" (was ").append(value).append(')');
            message = sb.toString();
        }
        return message;
    }

    private static void checkFloatRange(@NonNull JavaContext context, @NonNull JavaParser.ResolvedAnnotation annotation, @NonNull Node argument) {
        boolean toInclusive;
        boolean fromInclusive;
        double to;
        double from;
        Object object = ConstantEvaluator.evaluate(context, argument);
        if (!(object instanceof Number)) {
            return;
        }
        double value = ((Number)object).doubleValue();
        String message = SupportAnnotationDetector.getFloatRangeError(value, from = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_FROM, Double.NEGATIVE_INFINITY), to = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_TO, Double.POSITIVE_INFINITY), fromInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_FROM_INCLUSIVE, true), toInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_TO_INCLUSIVE, true), argument);
        if (message != null) {
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    @Nullable
    private static String getFloatRangeError(double value, double from, double to, boolean fromInclusive, boolean toInclusive, @NonNull Node node) {
        if (!((fromInclusive && value >= from || !fromInclusive && value > from) && (toInclusive && value <= to || !toInclusive && value < to))) {
            StringBuilder sb = new StringBuilder(20);
            if (from != Double.NEGATIVE_INFINITY) {
                if (to != Double.POSITIVE_INFINITY) {
                    if (fromInclusive && value < from || !fromInclusive && value <= from) {
                        sb.append("Value must be ");
                        if (fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(from));
                    } else {
                        assert (toInclusive && value > to || !toInclusive && value >= to);
                        sb.append("Value must be ");
                        if (toInclusive) {
                            sb.append('\u2264');
                        } else {
                            sb.append('<');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(to));
                    }
                } else {
                    sb.append("Value must be ");
                    if (fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(from));
                }
            } else if (to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(to));
            }
            sb.append(" (was ");
            if (node instanceof FloatingPointLiteral || node instanceof IntegralLiteral) {
                String str = node.toString();
                if (str.endsWith("f") || str.endsWith("F")) {
                    str = str.substring(0, str.length() - 1);
                }
                sb.append(str);
            } else {
                sb.append(value);
            }
            sb.append(')');
            return sb.toString();
        }
        return null;
    }

    private static void checkSize(@NonNull JavaContext context, @NonNull JavaParser.ResolvedAnnotation annotation, @NonNull Node argument) {
        int actual;
        StringLiteral literal;
        if (argument instanceof StringLiteral) {
            literal = (StringLiteral)argument;
            String s = literal.astValue();
            actual = s.length();
        } else if (argument instanceof ArrayCreation) {
            literal = (ArrayCreation)argument;
            ArrayInitializer initializer = literal.astInitializer();
            if (initializer == null) {
                return;
            }
            actual = initializer.astExpressions().size();
        } else {
            return;
        }
        long exact = SupportAnnotationDetector.getLongAttribute(annotation, "value", -1L);
        long min = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MIN, Long.MIN_VALUE);
        long max = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MAX, Long.MAX_VALUE);
        long multiple = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MULTIPLE, 1L);
        boolean isString = argument instanceof StringLiteral;
        String unit = isString ? "length" : "size";
        String message = SupportAnnotationDetector.getSizeError(actual, exact, min, max, multiple, unit);
        if (message != null) {
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getSizeError(long actual, long exact, long min, long max, long multiple, @NonNull String unit) {
        String message = null;
        if (exact != -1L) {
            if (exact != actual) {
                message = String.format("Expected %1$s %2$d (was %3$d)", unit, exact, actual);
            }
        } else if (actual < min || actual > max) {
            StringBuilder sb = new StringBuilder(20);
            if (actual < min) {
                sb.append("Expected ").append(unit).append(" \u2265 ");
                sb.append(Long.toString(min));
            } else {
                assert (actual > max);
                sb.append("Expected ").append(unit).append(" \u2264 ");
                sb.append(Long.toString(max));
            }
            sb.append(" (was ").append(actual).append(')');
            message = sb.toString();
        } else if (actual % multiple != 0L) {
            message = String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, multiple, actual, actual / multiple * multiple, (actual / multiple + 1L) * multiple);
        }
        return message;
    }

    private static void checkTypeDefConstant(@NonNull JavaContext context, @NonNull JavaParser.ResolvedAnnotation annotation, @NonNull Node argument, @Nullable Node errorNode, boolean flag) {
        if (argument instanceof NullLiteral) {
            return;
        }
        if (argument instanceof StringLiteral) {
            StringLiteral string = (StringLiteral)argument;
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, false, string.astValue());
        } else if (argument instanceof IntegralLiteral) {
            IntegralLiteral literal = (IntegralLiteral)argument;
            int value = literal.astIntValue();
            if (flag && value == 0) {
                return;
            }
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value);
        } else if (SupportAnnotationDetector.isMinusOne(argument)) {
            if (!flag) {
                SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode);
            }
        } else if (argument instanceof InlineIfExpression) {
            InlineIfExpression expression = (InlineIfExpression)argument;
            if (expression.astIfTrue() != null) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression.astIfTrue(), errorNode, flag);
            }
            if (expression.astIfFalse() != null) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression.astIfFalse(), errorNode, flag);
            }
        } else if (argument instanceof UnaryExpression) {
            UnaryExpression expression = (UnaryExpression)argument;
            UnaryOperator operator = expression.astOperator();
            if (flag) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression.astOperand(), errorNode, true);
            } else if (operator == UnaryOperator.BINARY_NOT) {
                context.report(TYPE_DEF, (Node)expression, context.getLocation((Node)expression), "Flag not allowed here");
            }
        } else if (argument instanceof BinaryExpression) {
            BinaryExpression expression = (BinaryExpression)argument;
            if (flag) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression.astLeft(), errorNode, true);
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression.astRight(), errorNode, true);
            } else {
                BinaryOperator operator = expression.astOperator();
                if (operator == BinaryOperator.BITWISE_AND || operator == BinaryOperator.BITWISE_OR || operator == BinaryOperator.BITWISE_XOR) {
                    context.report(TYPE_DEF, (Node)expression, context.getLocation((Node)expression), "Flag not allowed here");
                }
            }
        } else {
            Statement statement;
            JavaParser.ResolvedNode resolved = context.resolve(argument);
            if (resolved instanceof JavaParser.ResolvedField) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, resolved);
            } else if (argument instanceof VariableReference && (statement = JavaContext.getParentOfType(argument, Statement.class, false)) != null) {
                ListIterator iterator = statement.getParent().getChildren().listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != statement) continue;
                    if (!iterator.hasPrevious()) break;
                    iterator.previous();
                    break;
                }
                String targetName = ((VariableReference)argument).astIdentifier().astValue();
                while (iterator.hasPrevious()) {
                    BinaryExpression binaryExpression;
                    ExpressionStatement expressionStatement;
                    Expression expression;
                    Node previous = (Node)iterator.previous();
                    if (previous instanceof VariableDeclaration) {
                        VariableDeclaration declaration = (VariableDeclaration)previous;
                        VariableDefinition definition = declaration.astDefinition();
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)entry.astInitializer(), errorNode != null ? errorNode : argument, flag);
                            return;
                        }
                        continue;
                    }
                    if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)binaryExpression.astRight(), errorNode != null ? errorNode : argument, flag);
                    return;
                }
            }
        }
    }

    private static void checkTypeDefConstant(@NonNull JavaContext context, @NonNull JavaParser.ResolvedAnnotation annotation, @NonNull Node argument, @Nullable Node errorNode, boolean flag, Object value) {
        Object allowed = annotation.getValue();
        if (allowed instanceof Object[]) {
            Object[] allowedValues;
            for (Object o : allowedValues = (Object[])allowed) {
                if (!o.equals(value)) continue;
                return;
            }
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, flag, allowedValues);
        }
    }

    private static void reportTypeDef(@NonNull JavaContext context, @NonNull JavaParser.ResolvedAnnotation annotation, @NonNull Node argument, @Nullable Node errorNode) {
        Object allowed = annotation.getValue();
        if (allowed instanceof Object[]) {
            Object[] allowedValues = (Object[])allowed;
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, false, allowedValues);
        }
    }

    private static void reportTypeDef(@NonNull JavaContext context, @NonNull Node node, @Nullable Node errorNode, boolean flag, @NonNull Object[] allowedValues) {
        String values = SupportAnnotationDetector.listAllowedValues(allowedValues);
        String message = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        if (errorNode == null) {
            errorNode = node;
        }
        context.report(TYPE_DEF, errorNode, context.getLocation(errorNode), message);
    }

    /*
     * WARNING - void declaration
     */
    private static String listAllowedValues(@NonNull Object[] allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (Object allowedValue : allowedValues) {
            void var6_6;
            String s;
            if (allowedValue instanceof Integer) {
                s = allowedValue.toString();
            } else {
                if (!(allowedValue instanceof JavaParser.ResolvedNode)) continue;
                JavaParser.ResolvedNode node = (JavaParser.ResolvedNode)allowedValue;
                if (node instanceof JavaParser.ResolvedField) {
                    JavaParser.ResolvedField field = (JavaParser.ResolvedField)node;
                    String containingClassName = field.getContainingClassName();
                    containingClassName = containingClassName.substring(containingClassName.lastIndexOf(46) + 1);
                    s = containingClassName + "." + field.getName();
                } else {
                    s = node.getSignature();
                }
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((String)var6_6);
        }
        return sb.toString();
    }

    private static double getDoubleAttribute(@NonNull JavaParser.ResolvedAnnotation annotation, @NonNull String name, double defaultValue) {
        Object value = annotation.getValue(name);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return defaultValue;
    }

    private static long getLongAttribute(@NonNull JavaParser.ResolvedAnnotation annotation, @NonNull String name, long defaultValue) {
        Object value = annotation.getValue(name);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return defaultValue;
    }

    private static boolean getBoolean(@NonNull JavaParser.ResolvedAnnotation annotation, @NonNull String name, boolean defaultValue) {
        Object value = annotation.getValue(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    @Nullable
    static JavaParser.ResolvedAnnotation getRelevantAnnotation(@NonNull JavaParser.ResolvedAnnotation annotation) {
        String signature = annotation.getSignature();
        if (signature.startsWith("android.support.annotation.")) {
            if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) {
                return null;
            }
            return annotation;
        }
        if (signature.startsWith("java.")) {
            return null;
        }
        JavaParser.ResolvedClass type = annotation.getClassType();
        if (type != null) {
            for (JavaParser.ResolvedAnnotation inner : type.getAnnotations()) {
                if (!inner.matches("android.support.annotation.IntDef") && !inner.matches("android.support.annotation.StringDef") && !inner.matches(PERMISSION_ANNOTATION)) continue;
                return inner;
            }
        }
        return null;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(MethodInvocation.class);
    }

    @Override
    @Nullable
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new CallVisitor(context);
    }

    private class CallVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public CallVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitMethodInvocation(@NonNull MethodInvocation call) {
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)call);
            if (resolved instanceof JavaParser.ResolvedMethod) {
                JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                Iterable<JavaParser.ResolvedAnnotation> annotations = method.getAnnotations();
                for (JavaParser.ResolvedAnnotation resolvedAnnotation : annotations) {
                    JavaParser.ResolvedAnnotation resolvedAnnotation2 = SupportAnnotationDetector.getRelevantAnnotation(resolvedAnnotation);
                    if (resolvedAnnotation2 == null) continue;
                    SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, resolvedAnnotation2);
                }
                JavaParser.ResolvedClass containingClass = method.getContainingClass();
                annotations = containingClass.getAnnotations();
                for (JavaParser.ResolvedAnnotation annotation : annotations) {
                    if ((annotation = SupportAnnotationDetector.getRelevantAnnotation(annotation)) == null) continue;
                    SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, annotation);
                }
                Iterator iterator = call.astArguments().iterator();
                int n = method.getArgumentCount();
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    Expression argument = (Expression)iterator.next();
                    annotations = method.getParameterAnnotations(i);
                    for (JavaParser.ResolvedAnnotation annotation : annotations) {
                        if ((annotation = SupportAnnotationDetector.getRelevantAnnotation(annotation)) == null) continue;
                        SupportAnnotationDetector.checkParameterAnnotation(this.mContext, (Node)argument, annotation);
                    }
                }
            }
            return false;
        }
    }

    private static class CheckPermissionVisitor
    extends ForwardingAstVisitor {
        private boolean mChecksPermission;
        private boolean mDone;
        private final Node mTarget;

        public CheckPermissionVisitor(@NonNull Node target) {
            this.mTarget = target;
        }

        public boolean visitNode(Node node) {
            return this.mDone;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if (((name = node.astName().astValue()).startsWith("check") || name.startsWith("enforce")) && name.endsWith("Permission")) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
            return super.visitMethodInvocation(node);
        }

        public boolean checksPermission() {
            return this.mChecksPermission;
        }
    }
}

