/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Visitor;
import gnu.trove.TLongHashSet;
import java.util.ArrayDeque;
import java.util.Deque;

public class NonRecursiveVisitor
implements Visitor {
    protected final Deque<Instance> mStack = new ArrayDeque<Instance>();
    protected final TLongHashSet mSeen = new TLongHashSet();

    protected void defaultAction(Instance instance) {
    }

    @Override
    public void visitRootObj(@NonNull RootObj root) {
        this.defaultAction(root);
    }

    @Override
    public void visitArrayInstance(@NonNull ArrayInstance instance) {
        this.defaultAction(instance);
    }

    @Override
    public void visitClassInstance(@NonNull ClassInstance instance) {
        this.defaultAction(instance);
    }

    @Override
    public void visitClassObj(@NonNull ClassObj instance) {
        this.defaultAction(instance);
    }

    @Override
    public void visitLater(Instance parent, @NonNull Instance child) {
        this.mStack.push(child);
    }

    public void doVisit(Iterable<? extends Instance> startNodes) {
        for (Instance instance : startNodes) {
            if (instance instanceof RootObj) {
                instance.accept(this);
                continue;
            }
            this.visitLater(null, instance);
        }
        while (!this.mStack.isEmpty()) {
            Instance node = this.mStack.pop();
            if (!this.mSeen.add(node.getId())) continue;
            node.accept(this);
        }
    }
}

