/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Queries {
    private static final String DEFAULT_PACKAGE = "<default>";

    @NonNull
    public static Map<String, Set<ClassObj>> allClasses(@NonNull Snapshot snapshot) {
        return Queries.classes(snapshot, null);
    }

    @NonNull
    public static Map<String, Set<ClassObj>> classes(@NonNull Snapshot snapshot, @Nullable String[] excludedPrefixes) {
        TreeMap<String, Set<ClassObj>> result = new TreeMap<String, Set<ClassObj>>();
        TreeSet<ClassObj> classes = new TreeSet<ClassObj>();
        for (Heap heap : snapshot.mHeaps) {
            classes.addAll(heap.getClasses());
        }
        if (excludedPrefixes != null) {
            int N = excludedPrefixes.length;
            Iterator iter = classes.iterator();
            block1: while (iter.hasNext()) {
                ClassObj theClass = (ClassObj)iter.next();
                String classPath = theClass.toString();
                for (int i = 0; i < N; ++i) {
                    if (!classPath.startsWith(excludedPrefixes[i])) continue;
                    iter.remove();
                    continue block1;
                }
            }
        }
        for (ClassObj theClass : classes) {
            Set<ClassObj> classSet;
            String packageName = DEFAULT_PACKAGE;
            int lastDot = theClass.mClassName.lastIndexOf(46);
            if (lastDot != -1) {
                packageName = theClass.mClassName.substring(0, lastDot);
            }
            if ((classSet = result.get(packageName)) == null) {
                classSet = new TreeSet<ClassObj>();
                result.put(packageName, classSet);
            }
            classSet.add(theClass);
        }
        return result;
    }

    @NonNull
    public static Collection<ClassObj> commonClasses(@NonNull Snapshot first, @NonNull Snapshot second) {
        ArrayList<ClassObj> classes = new ArrayList<ClassObj>();
        for (Heap heap : first.getHeaps()) {
            for (ClassObj clazz : heap.getClasses()) {
                if (second.findClass(clazz.getClassName()) == null) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    public static ClassObj findClass(@NonNull Snapshot snapshot, String name) {
        return snapshot.findClass(name);
    }

    @NonNull
    public static Instance[] instancesOf(@NonNull Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        List<Instance> instances = theClass.getInstancesList();
        return instances.toArray(new Instance[instances.size()]);
    }

    @NonNull
    public static Instance[] allInstancesOf(@NonNull Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        ArrayList<ClassObj> classList = new ArrayList<ClassObj>();
        classList.add(theClass);
        classList.addAll(Queries.traverseSubclasses(theClass));
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (ClassObj someClass : classList) {
            instanceList.addAll(someClass.getInstancesList());
        }
        Instance[] result = new Instance[instanceList.size()];
        instanceList.toArray(result);
        return result;
    }

    @NonNull
    private static ArrayList<ClassObj> traverseSubclasses(@NonNull ClassObj base) {
        ArrayList<ClassObj> result = new ArrayList<ClassObj>();
        for (ClassObj subclass : base.mSubclasses) {
            result.add(subclass);
            result.addAll(Queries.traverseSubclasses(subclass));
        }
        return result;
    }

    public static Instance findObject(@NonNull Snapshot snapshot, String id) {
        long id2 = Long.parseLong(id, 16);
        return snapshot.findInstance(id2);
    }

    @NonNull
    public static Collection<RootObj> getRoots(@NonNull Snapshot snapshot) {
        HashSet<RootObj> result = new HashSet<RootObj>();
        for (Heap heap : snapshot.mHeaps) {
            result.addAll(heap.mRoots);
        }
        return result;
    }

    @NonNull
    public static final Instance[] newInstances(@NonNull Snapshot older, @NonNull Snapshot newer) {
        ArrayList<Instance> resultList = new ArrayList<Instance>();
        for (Heap newHeap : newer.mHeaps) {
            Heap oldHeap = older.getHeap(newHeap.getName());
            if (oldHeap == null) continue;
            for (Instance instance : newHeap.getInstances()) {
                Instance oldInstance = oldHeap.getInstance(instance.mId);
                if (oldInstance != null && instance.getClassObj() == oldInstance.getClassObj()) continue;
                resultList.add(instance);
            }
        }
        Instance[] resultArray = new Instance[resultList.size()];
        return resultList.toArray(resultArray);
    }
}

