/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace.viz;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.android.tools.perflib.vmtrace.viz.CallHierarchyRenderer;
import com.android.tools.perflib.vmtrace.viz.RenderContext;
import com.android.tools.perflib.vmtrace.viz.TimeScaleRenderer;
import com.android.tools.perflib.vmtrace.viz.ZoomPanInteractor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class TraceViewCanvas
extends JComponent {
    private static final Color BACKGROUND_COLOR = UIManager.getLookAndFeelDefaults().getColor("EditorPane.background");
    private static final int TOOLTIP_OFFSET = 10;
    private static final TimeUnit DEFAULT_TIME_UNITS = TimeUnit.NANOSECONDS;
    private final ZoomPanInteractor mZoomPanInteractor;
    private AffineTransform mViewPortTransform;
    private AffineTransform mViewPortInverseTransform;
    private VmTraceData mTraceData;
    private Call mTopLevelCall;
    private RenderContext mRenderContext;
    private TimeScaleRenderer mTimeScaleRenderer;
    private CallHierarchyRenderer mCallHierarchyRenderer;
    private final Point2D mTmpPoint = new Point2D.Double();

    public TraceViewCanvas() {
        this.mViewPortTransform = new AffineTransform();
        this.mViewPortInverseTransform = new AffineTransform();
        this.mZoomPanInteractor = new ZoomPanInteractor();
        this.addMouseListener(this.mZoomPanInteractor);
        this.addMouseMotionListener(this.mZoomPanInteractor);
        this.addMouseWheelListener(this.mZoomPanInteractor);
        this.mZoomPanInteractor.addViewTransformListener(new ZoomPanInteractor.ViewTransformListener(){

            @Override
            public void transformChanged(@NonNull AffineTransform transform) {
                TraceViewCanvas.this.updateViewPortTransform(transform);
            }
        });
        this.addMouseMotionListener(ToolTipManager.sharedInstance());
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                TraceViewCanvas.this.removeHierarchyBoundsListener(this);
                TraceViewCanvas.this.zoomFit();
            }
        });
    }

    public void setTrace(@NonNull VmTraceData traceData, @NonNull ThreadInfo thread, ClockType renderClock) {
        this.mTraceData = traceData;
        this.mRenderContext = new RenderContext(traceData, renderClock);
        this.displayThread(thread);
    }

    public void displayThread(@NonNull ThreadInfo thread) {
        this.mCallHierarchyRenderer = null;
        this.mTimeScaleRenderer = null;
        if (this.mTraceData == null) {
            return;
        }
        this.mTopLevelCall = thread.getTopLevelCall();
        if (this.mTopLevelCall == null) {
            return;
        }
        this.mTimeScaleRenderer = new TimeScaleRenderer(this.mTopLevelCall.getEntryTime(ClockType.GLOBAL, DEFAULT_TIME_UNITS), DEFAULT_TIME_UNITS);
        int yOffset = this.mTimeScaleRenderer.getLayoutHeight();
        this.mCallHierarchyRenderer = new CallHierarchyRenderer(this.mTraceData, thread, yOffset, DEFAULT_TIME_UNITS, this.mRenderContext);
        this.zoomFit();
    }

    public void setRenderClock(ClockType clock) {
        this.mRenderContext.setRenderClock(clock);
        this.repaint();
    }

    public void setUseInclusiveTimeForColorAssignment(boolean en) {
        this.mRenderContext.setUseInclusiveTimeForColorAssignment(en);
        this.repaint();
    }

    public void setHighlightMethods(@Nullable Set<MethodInfo> methods) {
        this.mRenderContext.setHighlightedMethods(methods);
        this.repaint();
    }

    public void zoomFit() {
        if (this.mTopLevelCall == null) {
            return;
        }
        long start = this.mTopLevelCall.getEntryTime(ClockType.GLOBAL, DEFAULT_TIME_UNITS);
        long end = this.mTopLevelCall.getExitTime(ClockType.GLOBAL, DEFAULT_TIME_UNITS);
        double width = this.getWidth();
        double sx = width * (double)0.9f / (double)(end - start);
        if (width < 10.0) {
            sx = Math.max(sx, 0.2);
        }
        this.mZoomPanInteractor.setToScaleX(sx, 1.0);
        this.mZoomPanInteractor.translateBy(50, 0);
        this.updateViewPortTransform(this.mZoomPanInteractor.getTransform());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.setRenderingHints(g2d);
        g2d.setColor(BACKGROUND_COLOR);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mTraceData == null) {
            return;
        }
        if (this.mCallHierarchyRenderer != null) {
            this.mCallHierarchyRenderer.render(g2d, this.mViewPortTransform);
        }
        if (this.mTimeScaleRenderer != null) {
            this.mTimeScaleRenderer.paint(g2d, this.mViewPortTransform, this.getWidth());
        }
    }

    private void setRenderingHints(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.mTraceData == null || this.mCallHierarchyRenderer == null) {
            return null;
        }
        this.mTmpPoint.setLocation(event.getPoint());
        this.mViewPortInverseTransform.transform(this.mTmpPoint, this.mTmpPoint);
        return this.mCallHierarchyRenderer.getToolTipFor(this.mTmpPoint.getX(), this.mTmpPoint.getY());
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return new Point(event.getX() + 10, event.getY() + 10);
    }

    private void updateViewPortTransform(AffineTransform tx) {
        this.mViewPortTransform = new AffineTransform(tx);
        try {
            this.mViewPortInverseTransform = this.mViewPortTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            this.mViewPortInverseTransform = new AffineTransform();
        }
        this.repaint();
    }
}

