/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;

public class HgFileRevision
implements VcsFileRevision {
    private final Project myProject;
    @NotNull
    private final HgFile myFile;
    @NotNull
    private final HgRevisionNumber myRevisionNumber;
    private final String myBranchName;
    private final Date myRevisionDate;
    private final String myAuthor;
    private final String myCommitMessage;
    private final Set<String> myFilesModified;
    private final Set<String> myFilesAdded;
    private final Set<String> myFilesDeleted;
    private final Map<String, String> myFilesCopied;

    public HgFileRevision(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber vcsRevisionNumber, String branchName, Date revisionDate, String author, String commitMessage, Set<String> filesModified, Set<String> filesAdded, Set<String> filesDeleted, Map<String, String> filesCopied) {
        if (hgFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/HgFileRevision", "<init>"));
        }
        if (vcsRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRevisionNumber", "org/zmlx/hg4idea/HgFileRevision", "<init>"));
        }
        this.myProject = project;
        this.myFile = hgFile;
        this.myRevisionNumber = vcsRevisionNumber;
        this.myBranchName = branchName;
        this.myRevisionDate = revisionDate;
        this.myAuthor = author;
        this.myCommitMessage = commitMessage;
        this.myFilesModified = filesModified;
        this.myFilesAdded = filesAdded;
        this.myFilesDeleted = filesDeleted;
        this.myFilesCopied = filesCopied;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        HgRevisionNumber hgRevisionNumber = this.myRevisionNumber;
        if (hgRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgFileRevision", "getRevisionNumber"));
        }
        return hgRevisionNumber;
    }

    public String getBranchName() {
        return this.myBranchName;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public Date getRevisionDate() {
        return this.myRevisionDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public Set<String> getModifiedFiles() {
        return this.myFilesModified;
    }

    public Set<String> getAddedFiles() {
        return this.myFilesAdded;
    }

    public Set<String> getDeletedFiles() {
        return this.myFilesDeleted;
    }

    public Map<String, String> getCopiedFiles() {
        return this.myFilesCopied;
    }

    @NotNull
    public byte[] loadContent() throws IOException, VcsException {
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myFile);
        byte[] byArray = HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgFileRevision", "loadContent"));
        }
        return byArray;
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgFileRevision revision = (HgFileRevision)o;
        if (!this.myFile.equals(revision.myFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myFile, this.myRevisionNumber});
    }
}

