/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.util.ConfigureUtil;

public class DefaultScriptHandler
implements ScriptHandler,
ScriptHandlerInternal {
    private static final Logger LOGGER = Logging.getLogger(DefaultScriptHandler.class);
    private final ScriptSource scriptSource;
    private final RepositoryHandler repositoryHandler;
    private final DependencyHandler dependencyHandler;
    private final ConfigurationContainer configContainer;
    private final ClassLoaderScope classLoaderScope;
    private Configuration classpathConfiguration;

    public DefaultScriptHandler(ScriptSource scriptSource, RepositoryHandler repositoryHandler, DependencyHandler dependencyHandler, ConfigurationContainer configContainer, ClassLoaderScope classLoaderScope) {
        this.repositoryHandler = repositoryHandler;
        this.dependencyHandler = dependencyHandler;
        this.scriptSource = scriptSource;
        this.configContainer = configContainer;
        this.classLoaderScope = classLoaderScope;
    }

    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    public void addScriptClassPathDependency(Object notation) {
        this.getDependencies().add("classpath", notation);
    }

    public ClassPath getScriptClassPath() {
        if (this.classpathConfiguration == null) {
            return new DefaultClassPath(new File[0]);
        }
        return new DefaultClassPath(this.classpathConfiguration.getFiles());
    }

    public DependencyHandler getDependencies() {
        this.defineConfiguration();
        return this.dependencyHandler;
    }

    public RepositoryHandler getRepositories() {
        return this.repositoryHandler;
    }

    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.repositoryHandler);
    }

    public ConfigurationContainer getConfigurations() {
        this.defineConfiguration();
        return this.configContainer;
    }

    private void defineConfiguration() {
        if (this.classpathConfiguration == null) {
            this.classpathConfiguration = (Configuration)this.configContainer.create("classpath");
        }
    }

    public File getSourceFile() {
        return this.scriptSource.getResource().getFile();
    }

    public URI getSourceURI() {
        return this.scriptSource.getResource().getURI();
    }

    public ClassLoader getClassLoader() {
        if (!this.classLoaderScope.isLocked()) {
            LOGGER.debug("Eager creation of script class loader for {}. This may result in performance issues.", this.scriptSource);
        }
        return this.classLoaderScope.getLocalClassLoader();
    }
}

