/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomPropertyDefiningTask;
import com.intellij.lang.ant.dom.AntPathValidatingConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.IOException;

public abstract class AntDomLoadFileTask
extends AntDomPropertyDefiningTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.dom.AntDomLoadFileTask");
    private String myCachedText;

    @Attribute(value="srcfile")
    @Convert(value=AntPathValidatingConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getSrcFile();

    @Attribute(value="encoding")
    public abstract GenericAttributeValue<String> getEncoding();

    @Override
    protected String calcPropertyValue(String propertyName) {
        String text = this.myCachedText;
        if (text != null) {
            return text;
        }
        PsiFileSystemItem file = (PsiFileSystemItem)this.getSrcFile().getValue();
        if (!(file instanceof PsiFile)) {
            return "";
        }
        VirtualFile vFile = ((PsiFile)file).getOriginalFile().getVirtualFile();
        if (vFile == null) {
            return "";
        }
        try {
            this.myCachedText = text = VfsUtil.loadText((VirtualFile)vFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            text = "";
        }
        return text;
    }
}

