/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.wizard.SelectExternalProjectStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportProvider;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.ImportFromGradleControl;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;

public class GradleProjectOpenProcessor
extends ProjectOpenProcessorBase<GradleProjectImportBuilder> {
    @NotNull
    public static final String[] BUILD_FILE_EXTENSIONS = new String[]{"gradle"};

    public GradleProjectOpenProcessor(@NotNull GradleProjectImportBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectOpenProcessor", "<init>"));
        }
        super((ProjectImportBuilder)builder);
    }

    @Nullable
    public String[] getSupportedExtensions() {
        return new String[]{"build.gradle", "settings.gradle"};
    }

    public boolean canOpenProject(VirtualFile file) {
        if (!file.isDirectory()) {
            String fileName = file.getName();
            for (String extension : BUILD_FILE_EXTENSIONS) {
                if (!fileName.endsWith(extension)) continue;
                return true;
            }
        }
        return super.canOpenProject(file);
    }

    protected boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        boolean result;
        GradleProjectImportProvider projectImportProvider = new GradleProjectImportProvider((GradleProjectImportBuilder)this.getBuilder());
        ((GradleProjectImportBuilder)this.getBuilder()).setFileToImport(file.getPath());
        ((GradleProjectImportBuilder)this.getBuilder()).prepare(wizardContext);
        ((ImportFromGradleControl)((GradleProjectImportBuilder)this.getBuilder()).getControl(null)).setLinkedProjectPath(file.getPath());
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            result = this.setupGradleProjectSettingsInHeadlessMode(file, projectImportProvider, wizardContext);
        } else {
            AddModuleWizard dialog = new AddModuleWizard(null, file.getPath(), new ProjectImportProvider[]{projectImportProvider});
            dialog.getWizardContext().setProjectBuilder((ProjectBuilder)this.getBuilder());
            dialog.navigateToStep((Function)new Function<Step, Boolean>(){

                public Boolean fun(Step step) {
                    return step instanceof SelectExternalProjectStep;
                }
            });
            result = dialog.showAndGet();
        }
        if (result && ((GradleProjectImportBuilder)this.getBuilder()).getExternalProjectNode() != null) {
            wizardContext.setProjectName(((ProjectData)((GradleProjectImportBuilder)this.getBuilder()).getExternalProjectNode().getData()).getInternalName());
        }
        return result;
    }

    private boolean setupGradleProjectSettingsInHeadlessMode(VirtualFile file, GradleProjectImportProvider projectImportProvider, WizardContext wizardContext) {
        ModuleWizardStep[] wizardSteps = projectImportProvider.createSteps(wizardContext);
        if (wizardSteps.length > 0 && wizardSteps[0] instanceof SelectExternalProjectStep) {
            SelectExternalProjectStep selectExternalProjectStep = (SelectExternalProjectStep)wizardSteps[0];
            wizardContext.setProjectBuilder((ProjectBuilder)this.getBuilder());
            try {
                selectExternalProjectStep.updateStep();
                ImportFromGradleControl importFromGradleControl = (ImportFromGradleControl)((GradleProjectImportBuilder)this.getBuilder()).getControl(wizardContext.getProject());
                GradleProjectSettingsControl gradleProjectSettingsControl = (GradleProjectSettingsControl)importFromGradleControl.getProjectSettingsControl();
                GradleProjectSettings projectSettings = (GradleProjectSettings)gradleProjectSettingsControl.getInitialSettings();
                if (GradleEnvironment.Headless.GRADLE_DISTRIBUTION_TYPE != null) {
                    for (DistributionType type : DistributionType.values()) {
                        if (!type.name().equals(GradleEnvironment.Headless.GRADLE_DISTRIBUTION_TYPE)) continue;
                        projectSettings.setDistributionType(type);
                        break;
                    }
                }
                if (GradleEnvironment.Headless.GRADLE_HOME != null) {
                    projectSettings.setGradleHome(GradleEnvironment.Headless.GRADLE_HOME);
                }
                gradleProjectSettingsControl.reset();
                GradleSystemSettingsControl systemSettingsControl = (GradleSystemSettingsControl)importFromGradleControl.getSystemSettingsControl();
                assert (systemSettingsControl != null);
                GradleSettings gradleSettings = systemSettingsControl.getInitialSettings();
                if (GradleEnvironment.Headless.GRADLE_VM_OPTIONS != null) {
                    gradleSettings.setGradleVmOptions(GradleEnvironment.Headless.GRADLE_VM_OPTIONS);
                }
                if (GradleEnvironment.Headless.GRADLE_OFFLINE != null) {
                    gradleSettings.setOfflineWork(Boolean.parseBoolean(GradleEnvironment.Headless.GRADLE_OFFLINE));
                }
                String serviceDirectory = GradleEnvironment.Headless.GRADLE_SERVICE_DIRECTORY;
                if (GradleEnvironment.Headless.GRADLE_SERVICE_DIRECTORY != null) {
                    gradleSettings.setServiceDirectoryPath(serviceDirectory);
                }
                systemSettingsControl.reset();
                if (!selectExternalProjectStep.validate()) {
                    return false;
                }
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)wizardContext.getProject(), (String)e.getMessage(), (String)e.getTitle());
                return false;
            }
            selectExternalProjectStep.updateDataModel();
        }
        return true;
    }

    public boolean lookForProjectsInDirectory() {
        return false;
    }
}

