/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;

class ParamDocTagInfo
implements JavadocTagInfo {
    ParamDocTagInfo() {
    }

    @Override
    public String getName() {
        return "param";
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        return element instanceof PsiMethod || element instanceof PsiClass && PsiUtil.isLanguageLevel5OrHigher(element);
    }

    @Override
    public Object[] getPossibleValues(PsiElement context, PsiElement place, String prefix) {
        if (context instanceof PsiTypeParameterListOwner) {
            ArrayList<PsiTypeParameter> result2 = new ArrayList<PsiTypeParameter>(Arrays.asList(((PsiTypeParameterListOwner)context).getTypeParameters()));
            if (context instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)context;
                ContainerUtil.addAll(result2, method.getParameterList().getParameters());
            }
            return result2.toArray(new PsiNamedElement[result2.size()]);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value2) {
        if (value2 == null) {
            return JavaErrorMessages.message("javadoc.param.tag.parameter.name.expected", new Object[0]);
        }
        ASTNode firstChildNode = value2.getNode().getFirstChildNode();
        if (firstChildNode != null && firstChildNode.getElementType().equals(JavaDocTokenType.DOC_TAG_VALUE_LT)) {
            if (value2.getNode().findChildByType(JavaDocTokenType.DOC_TAG_VALUE_TOKEN) == null) {
                return JavaErrorMessages.message("javadoc.param.tag.type.parameter.name.expected", new Object[0]);
            }
            if (value2.getNode().findChildByType(JavaDocTokenType.DOC_TAG_VALUE_GT) == null) {
                return JavaErrorMessages.message("javadoc.param.tag.type.parameter.gt.expected", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value2) {
        if (value2 instanceof PsiDocParamRef) {
            return value2.getReference();
        }
        return null;
    }

    @Override
    public boolean isInline() {
        return false;
    }
}

