/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

class SeeDocTagInfo
implements JavadocTagInfo {
    private final String myName;
    private final boolean myInline;

    public SeeDocTagInfo(@NonNls String name, boolean isInline) {
        this.myName = name;
        this.myInline = isInline;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value2) {
        return null;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Object[] getPossibleValues(PsiElement context, PsiElement place, String prefix) {
        if (place instanceof PsiDocToken) {
            PsiDocToken token = (PsiDocToken)place;
            if (token.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                return this.getPossibleMethodsAndFields(context, place, prefix);
            }
            if (token.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
                PsiMethod[] methods;
                if (token.getPrevSibling() == null) {
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                String methodName = token.getPrevSibling().getText();
                PsiElement targetContext = this.getTargetContext(context, place);
                ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
                for (PsiMethod method : methods = PsiDocMethodOrFieldRef.getAllMethods(targetContext, place)) {
                    if (!method.getName().equals(methodName)) continue;
                    result2.add(method);
                }
                return ArrayUtil.toObjectArray(result2);
            }
            if (token.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN && place.getParent() instanceof PsiDocMethodOrFieldRef) {
                return this.getPossibleMethodsAndFields(context, place, prefix);
            }
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private Object[] getPossibleMethodsAndFields(PsiElement context, PsiElement place, String prefix) {
        PsiVariable[] variables;
        PsiMethod[] methods;
        ArrayList<PsiModifierListOwner> result2 = new ArrayList<PsiModifierListOwner>();
        PsiElement targetContext = this.getTargetContext(context, place);
        for (PsiMethod method : methods = PsiDocMethodOrFieldRef.getAllMethods(targetContext, place)) {
            result2.add(method);
        }
        for (PsiVariable variable : variables = PsiDocMethodOrFieldRef.getAllVariables(targetContext, place)) {
            result2.add(variable);
        }
        return ArrayUtil.toObjectArray(result2);
    }

    private PsiElement getTargetContext(PsiElement context, PsiElement place) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement element;
        PsiDocMethodOrFieldRef methodRef;
        IElementType firstChildType;
        PsiElement targetContext = context;
        if (place.getParent() instanceof PsiDocMethodOrFieldRef && ((firstChildType = (methodRef = (PsiDocMethodOrFieldRef)place.getParent()).getFirstChildNode().getElementType()) == JavaElementType.JAVA_CODE_REFERENCE || firstChildType == JavaElementType.REFERENCE_EXPRESSION) && (element = (referenceElement = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(methodRef.getFirstChildNode())).resolve()) instanceof PsiClass) {
            targetContext = element.getFirstChild();
        }
        return targetContext;
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        if (this.myInline && this.myName.equals("linkplain") && element != null) {
            return PsiUtil.getLanguageLevel(element).compareTo(LanguageLevel.JDK_1_4) >= 0;
        }
        return true;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value2) {
        return null;
    }

    @Override
    public boolean isInline() {
        return this.myInline;
    }
}

