/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectMap<IntReference<V>> myMap = ContainerUtil.createConcurrentIntObjectMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentRefValueIntObjectHashMap() {
    }

    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    @Override
    public boolean remove(int key, @NotNull V value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "remove"));
        }
        this.processQueue();
        return this.myMap.remove(key, this.createReference(key, value2, this.myQueue));
    }

    @Override
    public V put(int key, @NotNull V value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "put"));
        }
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value2, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    @NotNull
    public Iterable<ConcurrentIntObjectMap.IntEntry<V>> entries() {
        final Iterator<ConcurrentIntObjectMap.IntEntry<IntReference<V>>> entryIterator = this.myMap.entries().iterator();
        Iterable iterable = new Iterable<ConcurrentIntObjectMap.IntEntry<V>>(){

            @Override
            public Iterator<ConcurrentIntObjectMap.IntEntry<V>> iterator() {
                return new Iterator<ConcurrentIntObjectMap.IntEntry<V>>(){
                    ConcurrentIntObjectMap.IntEntry<V> next = this.nextAliveEntry();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public ConcurrentIntObjectMap.IntEntry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ConcurrentIntObjectMap.IntEntry result2 = this.next;
                        this.next = this.nextAliveEntry();
                        return result2;
                    }

                    private ConcurrentIntObjectMap.IntEntry<V> nextAliveEntry() {
                        while (entryIterator.hasNext()) {
                            ConcurrentIntObjectMap.IntEntry entry = (ConcurrentIntObjectMap.IntEntry)entryIterator.next();
                            final Object v = ((IntReference)entry.getValue()).get();
                            if (v == null) continue;
                            final int key = entry.getKey();
                            return new ConcurrentIntObjectMap.IntEntry<V>(){

                                @Override
                                public int getKey() {
                                    return key;
                                }

                                @Override
                                @NotNull
                                public V getValue() {
                                    Object object = v;
                                    if (object == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap$1$1$1", "getValue"));
                                    }
                                    return object;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "entries"));
        }
        return iterable;
    }

    protected static interface IntReference<V> {
        public int getKey();

        public V get();
    }
}

