/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class CodegenUtil {
    private CodegenUtil() {
    }

    @Nullable
    public static FunctionDescriptor getDeclaredFunctionByRawSignature(@NotNull ClassDescriptor owner, @NotNull Name name, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        Collection<FunctionDescriptor> functions2 = owner.getDefaultType().getMemberScope().getContributedFunctions(name, NoLookupLocation.FROM_BACKEND);
        for (FunctionDescriptor function : functions2) {
            if (CallResolverUtilKt.isOrOverridesSynthesized(function) || !function.getTypeParameters().isEmpty() || !CodegenUtil.valueParameterClassesMatch(function.getValueParameters(), Arrays.asList(valueParameterClassifiers)) || !CodegenUtil.rawTypeMatches(function.getReturnType(), returnedClassifier)) continue;
            return function;
        }
        return null;
    }

    @Nullable
    public static PropertyDescriptor getDelegatePropertyIfAny(KtExpression expression, ClassDescriptor classDescriptor, BindingContext bindingContext2) {
        ValueParameterDescriptor valueParameterDescriptor;
        CallableDescriptor callResultingDescriptor;
        ResolvedCall<? extends CallableDescriptor> call;
        PropertyDescriptor propertyDescriptor = null;
        if (expression instanceof KtSimpleNameExpression && (call = CallUtilKt.getResolvedCall(expression, bindingContext2)) != null && (callResultingDescriptor = call.getResultingDescriptor()) instanceof ValueParameterDescriptor && (valueParameterDescriptor = (ValueParameterDescriptor)callResultingDescriptor).getContainingDeclaration() instanceof ConstructorDescriptor && valueParameterDescriptor.getContainingDeclaration().getContainingDeclaration() == classDescriptor) {
            propertyDescriptor = bindingContext2.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameterDescriptor);
        }
        return propertyDescriptor;
    }

    public static boolean isFinalPropertyWithBackingField(PropertyDescriptor propertyDescriptor, BindingContext bindingContext2) {
        return propertyDescriptor != null && !propertyDescriptor.isVar() && Boolean.TRUE.equals(bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
    }

    @NotNull
    public static Map<FunctionDescriptor, FunctionDescriptor> getTraitMethods(ClassDescriptor descriptor2) {
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> result2 = new LinkedHashMap<FunctionDescriptor, FunctionDescriptor>();
        for (DeclarationDescriptor declaration : DescriptorUtils.getAllDescriptors(descriptor2.getDefaultType().getMemberScope())) {
            CallableMemberDescriptor inheritedMember;
            CallableMemberDescriptor traitMember;
            if (!(declaration instanceof CallableMemberDescriptor) || (traitMember = ImplKt.findTraitImplementation(inheritedMember = (CallableMemberDescriptor)declaration)) == null) continue;
            assert (traitMember.getModality() != Modality.ABSTRACT) : "Cannot delegate to abstract trait method: " + inheritedMember;
            result2.putAll(CodegenUtil.copyFunctions(inheritedMember, traitMember, inheritedMember.getContainingDeclaration(), traitMember.getModality(), Visibilities.PUBLIC, CallableMemberDescriptor.Kind.DECLARATION, true));
        }
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getTraitMethods"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static Map<FunctionDescriptor, FunctionDescriptor> copyFunctions(@NotNull CallableMemberDescriptor inheritedMember, @NotNull CallableMemberDescriptor traitMember, DeclarationDescriptor newOwner, Modality modality, Visibility visibility, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        if (inheritedMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritedMember", "org/jetbrains/kotlin/backend/common/CodegenUtil", "copyFunctions"));
        }
        if (traitMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitMember", "org/jetbrains/kotlin/backend/common/CodegenUtil", "copyFunctions"));
        }
        CallableMemberDescriptor copy2 = inheritedMember.copy(newOwner, modality, visibility, kind, copyOverrides);
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> result2 = new LinkedHashMap<FunctionDescriptor, FunctionDescriptor>(0);
        if (traitMember instanceof SimpleFunctionDescriptor) {
            result2.put((FunctionDescriptor)traitMember, (FunctionDescriptor)copy2);
        } else if (traitMember instanceof PropertyDescriptor) {
            for (PropertyAccessorDescriptor traitAccessor : ((PropertyDescriptor)traitMember).getAccessors()) {
                for (PropertyAccessorDescriptor inheritedAccessor : ((PropertyDescriptor)copy2).getAccessors()) {
                    if (inheritedAccessor.getClass() != traitAccessor.getClass()) continue;
                    result2.put(traitAccessor, inheritedAccessor);
                }
            }
        }
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/CodegenUtil", "copyFunctions"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static ClassDescriptor getSuperClassByDelegationSpecifier(@NotNull KtDelegationSpecifier specifier, @NotNull BindingContext bindingContext2) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getSuperClassByDelegationSpecifier"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getSuperClassByDelegationSpecifier"));
        }
        KotlinType superType = bindingContext2.get(BindingContext.TYPE, specifier.getTypeReference());
        assert (superType != null) : "superType should not be null: " + specifier.getText();
        ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
        assert (superClassDescriptor != null) : "superClassDescriptor should not be null: " + specifier.getText();
        ClassDescriptor classDescriptor = superClassDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getSuperClassByDelegationSpecifier"));
        }
        return classDescriptor;
    }

    private static boolean valueParameterClassesMatch(@NotNull List<ValueParameterDescriptor> parameters2, @NotNull List<ClassifierDescriptor> classifiers) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/backend/common/CodegenUtil", "valueParameterClassesMatch"));
        }
        if (classifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifiers", "org/jetbrains/kotlin/backend/common/CodegenUtil", "valueParameterClassesMatch"));
        }
        if (parameters2.size() != classifiers.size()) {
            return false;
        }
        for (int i = 0; i < parameters2.size(); ++i) {
            ValueParameterDescriptor parameterDescriptor = parameters2.get(i);
            ClassifierDescriptor classDescriptor = classifiers.get(i);
            if (CodegenUtil.rawTypeMatches(parameterDescriptor.getType(), classDescriptor)) continue;
            return false;
        }
        return true;
    }

    private static boolean rawTypeMatches(KotlinType type2, ClassifierDescriptor classifier2) {
        return type2.getConstructor().equals(classifier2.getTypeConstructor());
    }

    public static boolean isEnumValueOfMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/backend/common/CodegenUtil", "isEnumValueOfMethod"));
        }
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        KotlinType nullableString = TypeUtils.makeNullable(DescriptorUtilsKt.getBuiltIns(functionDescriptor).getStringType());
        return DescriptorUtils.ENUM_VALUE_OF.equals(functionDescriptor.getName()) && methodTypeParameters.size() == 1 && KotlinTypeChecker.DEFAULT.isSubtypeOf(methodTypeParameters.get(0).getType(), nullableString);
    }

    public static boolean isEnumValuesProperty(@NotNull VariableDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/backend/common/CodegenUtil", "isEnumValuesProperty"));
        }
        return DescriptorUtils.ENUM_VALUES.equals(propertyDescriptor.getName());
    }

    @Nullable
    public static Integer getLineNumberForElement(@NotNull PsiElement statement, boolean markEndOffset) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/backend/common/CodegenUtil", "getLineNumberForElement"));
        }
        PsiFile file = statement.getContainingFile();
        if (file instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file) != null) {
            return null;
        }
        Document document = file.getViewProvider().getDocument();
        return document != null ? Integer.valueOf(document.getLineNumber(markEndOffset ? statement.getTextRange().getEndOffset() : statement.getTextOffset()) + 1) : null;
    }
}

