/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import com.google.protobuf.ExtensionRegistryLite;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsProtoBuf;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rAaY\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K!!1\u0002c\u0003\u000e\u0003a\u0011\u0011d\u0001\u0005\u0007\u001b\u0005Aj!\n\u0005\u0005\u0017!9Q\"\u0001\r\u00033\rAy!D\u0001\u0019\u0011\u0015BAa\u0003E\t\u001b\u0005A\"!G\u0002\t\u00105\t\u0001\u0004C\u0013\t\t\u0005A\u0011\"D\u0001\u0019\u0005e\u0019\u0001rB\u0007\u00021!)\u0003\u0002B\u0001\t\u00145\t\u0001DA\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005*\u0010\u0011\t\u0005*\u0001E\u0002\u001b\u0005A\"!U\u0002\u0002\u000b\u0001I{\u0001B!I\u0003!\u0015Q\"\u0001\r\u0003#\u000e\tQ\u0001AU\b\t\u0005C\u0015\u0001C\u0002\u000e\u0003a\u0011\u0011kA\u0001\u0006\u0001%RAa\u0013\u0005\t\b5\t\u0001\u0004B)\u0004\t\u0015\u0001QB\u0001C\u0005\u0011\u0015\u0001"}, strings={"Lorg/jetbrains/kotlin/builtins/BuiltInsSerializedResourcePaths;", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "()V", "CLASS_METADATA_FILE_EXTENSION", "", "PACKAGE_FILE_EXTENSION", "STRING_TABLE_FILE_EXTENSION", "extensionRegistry", "Lcom/google/protobuf/ExtensionRegistryLite;", "getExtensionRegistry", "()Lcom/google/protobuf/ExtensionRegistryLite;", "getClassMetadataPath", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackageFilePath", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getStringTableFilePath", "packageFqNameToPath", "shortName"}, moduleName="kotlin-compiler")
public final class BuiltInsSerializedResourcePaths
extends SerializedResourcePaths {
    @NotNull
    public static final ExtensionRegistryLite extensionRegistry;
    private static final String CLASS_METADATA_FILE_EXTENSION = "kotlin_class";
    private static final String PACKAGE_FILE_EXTENSION = "kotlin_package";
    private static final String STRING_TABLE_FILE_EXTENSION = "kotlin_string_table";
    public static final BuiltInsSerializedResourcePaths INSTANCE;
    public static final BuiltInsSerializedResourcePaths INSTANCE$;

    @Override
    @NotNull
    public ExtensionRegistryLite getExtensionRegistry() {
        return extensionRegistry;
    }

    @Override
    @NotNull
    public String getClassMetadataPath(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        StringBuilder stringBuilder = new StringBuilder();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.getPackageFqName()");
        return stringBuilder.append(this.packageFqNameToPath(fqName2)).append("/").append(classId.getRelativeClassName().asString()).append(".").append(CLASS_METADATA_FILE_EXTENSION).toString();
    }

    @Override
    @NotNull
    public String getPackageFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + PACKAGE_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getStringTableFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + STRING_TABLE_FILE_EXTENSION;
    }

    private final String packageFqNameToPath(FqName fqName2) {
        return StringsKt.replace$default(fqName2.asString(), '.', '/', false, 4);
    }

    private final String shortName(FqName fqName2) {
        String string;
        if (fqName2.isRoot()) {
            string = "default-package";
        } else {
            String string2 = fqName2.shortName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "fqName.shortName().asString()");
        }
        return string;
    }

    static {
        new BuiltInsSerializedResourcePaths();
    }

    private BuiltInsSerializedResourcePaths() {
        INSTANCE = this;
        INSTANCE$ = this;
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        Intrinsics.checkExpressionValueIsNotNull(extensionRegistryLite, "ExtensionRegistryLite.newInstance()");
        extensionRegistry = extensionRegistryLite;
        BuiltInsProtoBuf.registerAllExtensions(this.getExtensionRegistry());
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
        PACKAGE_FILE_EXTENSION = PACKAGE_FILE_EXTENSION;
        STRING_TABLE_FILE_EXTENSION = STRING_TABLE_FILE_EXTENSION;
    }
}

