/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionReferenceGenerationStrategy
extends FunctionGenerationStrategy.CodegenBased<FunctionDescriptor> {
    private final ResolvedCall<?> resolvedCall;
    private final FunctionDescriptor referencedFunction;

    public FunctionReferenceGenerationStrategy(@NotNull GenerationState state, @NotNull FunctionDescriptor functionDescriptor, @NotNull ResolvedCall<?> resolvedCall) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "<init>"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "<init>"));
        }
        super(state, functionDescriptor);
        this.resolvedCall = resolvedCall;
        this.referencedFunction = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
    }

    @Override
    public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
        StackValue result2;
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "doGenerateBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "doGenerateBody"));
        }
        KtCallExpression fakeExpression = this.constructFakeFunctionCall();
        final List<KtValueArgument> fakeArguments = fakeExpression.getValueArguments();
        final ReceiverValue dispatchReceiver = this.computeAndSaveReceiver(signature, codegen, this.referencedFunction.getDispatchReceiverParameter());
        final ReceiverValue extensionReceiver2 = this.computeAndSaveReceiver(signature, codegen, this.referencedFunction.getExtensionReceiverParameter());
        this.computeAndSaveArguments(fakeArguments, codegen);
        DelegatingResolvedCall<CallableDescriptor> fakeResolvedCall = new DelegatingResolvedCall<CallableDescriptor>(this.resolvedCall){
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> argumentMap;
            {
                super(x0);
                this.argumentMap = new LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument>(fakeArguments.size());
                int index2 = 0;
                List<ValueParameterDescriptor> parameters2 = ((FunctionDescriptor)FunctionReferenceGenerationStrategy.this.callableDescriptor).getValueParameters();
                for (ValueArgument argument : fakeArguments) {
                    this.argumentMap.put(parameters2.get(index2), new ExpressionValueArgument(argument));
                    ++index2;
                }
            }

            @Override
            @NotNull
            public ReceiverValue getExtensionReceiver() {
                ReceiverValue receiverValue = extensionReceiver2;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1", "getExtensionReceiver"));
                }
                return receiverValue;
            }

            @Override
            @NotNull
            public ReceiverValue getDispatchReceiver() {
                ReceiverValue receiverValue = dispatchReceiver;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1", "getDispatchReceiver"));
                }
                return receiverValue;
            }

            @Override
            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                ArrayList<ResolvedValueArgument> arrayList = new ArrayList<ResolvedValueArgument>(this.argumentMap.values());
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1", "getValueArgumentsByIndex"));
                }
                return arrayList;
            }

            @Override
            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = this.argumentMap;
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1", "getValueArguments"));
                }
                return map2;
            }
        };
        Type returnType2 = codegen.getReturnType();
        if (this.referencedFunction instanceof ConstructorDescriptor) {
            result2 = returnType2.getSort() == 9 ? codegen.generateNewArray(fakeExpression, this.referencedFunction.getReturnType()) : codegen.generateConstructorCall(fakeResolvedCall, returnType2);
        } else {
            Call call = CallMaker.makeCall(fakeExpression, ReceiverValue.NO_RECEIVER, null, fakeExpression, fakeArguments);
            result2 = codegen.invokeFunction(call, fakeResolvedCall, StackValue.none());
        }
        InstructionAdapter v = codegen.v;
        result2.put(returnType2, v);
        v.areturn(returnType2);
    }

    @NotNull
    private KtCallExpression constructFakeFunctionCall() {
        StringBuilder fakeFunctionCall = new StringBuilder("callableReferenceFakeCall(");
        Iterator<ValueParameterDescriptor> iterator2 = this.referencedFunction.getValueParameters().iterator();
        while (iterator2.hasNext()) {
            ValueParameterDescriptor descriptor2 = iterator2.next();
            fakeFunctionCall.append("p").append(descriptor2.getIndex());
            if (!iterator2.hasNext()) continue;
            fakeFunctionCall.append(", ");
        }
        fakeFunctionCall.append(")");
        KtCallExpression ktCallExpression = (KtCallExpression)KtPsiFactoryKt.KtPsiFactory(this.state.getProject()).createExpression(fakeFunctionCall.toString());
        if (ktCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "constructFakeFunctionCall"));
        }
        return ktCallExpression;
    }

    private void computeAndSaveArguments(@NotNull List<? extends ValueArgument> fakeArguments, @NotNull ExpressionCodegen codegen) {
        if (fakeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeArguments", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveArguments"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveArguments"));
        }
        int receivers = (this.referencedFunction.getDispatchReceiverParameter() != null ? 1 : 0) + (this.referencedFunction.getExtensionReceiverParameter() != null ? 1 : 0);
        List<ValueParameterDescriptor> parameters2 = CollectionsKt.drop(((FunctionDescriptor)this.callableDescriptor).getValueParameters(), receivers);
        for (int i = 0; i < parameters2.size(); ++i) {
            ValueParameterDescriptor parameter = parameters2.get(i);
            ValueArgument fakeArgument = fakeArguments.get(i);
            Type type2 = this.state.getTypeMapper().mapType(parameter);
            int localIndex = codegen.myFrameMap.getIndex(parameter);
            codegen.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(localIndex, type2));
        }
    }

    @NotNull
    private ReceiverValue computeAndSaveReceiver(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen, @Nullable ReceiverParameterDescriptor receiver) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveReceiver"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveReceiver"));
        }
        if (receiver == null) {
            ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
            if (receiverValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveReceiver"));
            }
            return receiverValue;
        }
        KtExpression receiverExpression = KtPsiFactoryKt.KtPsiFactory(this.state.getProject()).createExpression("callableReferenceFakeReceiver");
        codegen.tempVariables.put(receiverExpression, FunctionReferenceGenerationStrategy.receiverParameterStackValue(signature));
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(receiverExpression, receiver.getType());
        if (expressionReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveReceiver"));
        }
        return expressionReceiver;
    }

    @NotNull
    private static StackValue.Local receiverParameterStackValue(@NotNull JvmMethodSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "receiverParameterStackValue"));
        }
        StackValue.Local local = StackValue.local(1, signature.getAsmMethod().getArgumentTypes()[0]);
        if (local == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "receiverParameterStackValue"));
        }
        return local;
    }
}

