/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegationSpecifierList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005a\u0011!B\u0001\u0005\t\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u0012\u0015\tA\"A\u0003\u0002\t\u0005!1-\u0001\u0007\u00013\u0005A\n!(A5C\u000f!\u0011!U\u0002\u0002\u0011\u0005);\u0003b\u0002\te5!\u0011BA\u0005\u00021\u000bA\"!G\u0005\tf5)\u0011b\u0001C\u0001\u0013\u0005A:\u0007G\u001a\u0012\u0003a\u001d\u0014kA\u0001\ti%jAa\u0011\u0005\t\u00045!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0005\u000b\u0001i!\u0001B\u0002\t\b%jAa\u0011\u0005\t\t5!\u0011BA\u0005\u00021\u0013A\"!U\u0002\u0005\u000b\u0001i!\u0001B\u0003\t\b%jAa\u0011\u0005\t\f5!\u0011BA\u0005\u00021\u0019A\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0004\t\b%jAa\u0011\u0005\t\u000f5!\u0011BA\u0005\u00021\u001fA\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0005\t\b%jAa\u0011\u0005\t\u00125!\u0011BA\u0005\u00021\u001fA\"!U\u0002\u0005\u000b\u0001i!\u0001B\u0005\t\b%jAa\u0011\u0005\t\u00145!\u0011BA\u0005\u00021)A\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0006\t\b%jAa\u0011\u0005\t\u00175!\u0011BA\u0005\u00021/A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0007\t\b%jAa\u0011\u0005\t\u001a5!\u0011BA\u0005\u000215A\"!U\u0002\u0005\u000b\u0001i!\u0001b\u0007\t\b%jAa\u0011\u0005\t\u001d5!\u0011BA\u0005\u00021;A\"!U\u0002\u0005\u000b\u0001i!\u0001B\b\t\b%jAa\u0011\u0005\t 5!\u0011BA\u0005\u00021;A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\t\t\b%jAa\u0011\u0005\t\"5!\u0011BA\u0005\u00021\u001fA\"!U\u0002\u0005\u000b\u0001i!\u0001B\t\t\b%jAa\u0011\u0005\t$5!\u0011BA\u0005\u00021IA\"!U\u0002\u0005\u000b\u0001i!\u0001\"\n\t\b%jAa\u0011\u0005\t'5!\u0011BA\u0005\u00021\u001fA\"!U\u0002\u0005\u000b\u0001i!\u0001b\n\t\b%jAa\u0011\u0005\t)5!\u0011BA\u0005\u00021SA\"!U\u0002\u0005\u000b\u0001i!\u0001B\u000b\t\b%jAa\u0011\u0005\t,5!\u0011BA\u0005\u00021YA\"!U\u0002\u0005\u000b\u0001i!\u0001\"\f\t\b%jAa\u0011\u0005\t/5!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0005\u000b\u0001i!\u0001b\f\t\b%jAa\u0011\u0005\t15!\u0011BA\u0005\u00021\u001fA\"!U\u0002\u0005\u000b\u0001i!\u0001\"\r\t\b%jAa\u0011\u0005\t35!\u0011BA\u0005\u00021gA\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u000e\t\b%jAa\u0011\u0005\t65!\u0011BA\u0005\u00021mA\"!U\u0002\u0005\u000b\u0001i!\u0001b\u000e\t\b%jAa\u0011\u0005\t95!\u0011BA\u0005\u00021sA\"!U\u0002\u0005\u000b\u0001i!\u0001B\u000f\t\b%jAa\u0011\u0005\t<5!\u0011BA\u0005\u00021/A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0010\t\b%jAa\u0011\u0005\t>5!\u0011BA\u0005\u00021}A\"!U\u0002\u0005\u000b\u0001i!\u0001b\u0010\t\b%jAa\u0011\u0005\tA5!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0011\t\b%jAa\u0011\u0005\tC5!\u0011BA\u0005\u00021\u0007B\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0012\t\b%jAa\u0011\u0005\tF5!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0005\u000b\u0001i!\u0001B\u0012\t\b%jAa\u0011\u0005\tH5!\u0011BA\u0005\u00021\u0011B\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0013\t\b%jAa\u0011\u0005\tK5!\u0011BA\u0005\u00021;A\"!U\u0002\u0005\u000b\u0001i!\u0001b\u0013\t\b%jAa\u0011\u0005\tM5!\u0011BA\u0005\u00021\u001fA\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0014\t\b%jAa\u0011\u0005\tO5!\u0011BA\u0005\u00021\u001fB\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0015\t\b%jAa\u0011\u0005\tR5!\u0011BA\u0005\u00021\u001fB\"!U\u0002\u0005\u000b\u0001i!\u0001B\u0015\t\b%jAa\u0011\u0005\tT5!\u0011BA\u0005\u00021/A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0016\t\b%jAa\u0011\u0005\tV5!\u0011BA\u0005\u000215A\"!U\u0002\u0005\u000b\u0001i!\u0001B\u0016\t\b%jAa\u0011\u0005\tX5!\u0011BA\u0005\u000211B\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0017\t\b%jAa\u0011\u0005\t[5!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0005\u000b\u0001i!\u0001b\u0017\t\b%jAa\u0011\u0005\t]5!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0018\t\b%jAa\u0011\u0005\t_5!\u0011BA\u0005\u00021?B\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0019\t\b%jAa\u0011\u0005\tb5!\u0011BA\u0005\u00021EB\"!U\u0002\u0005\u000b\u0001i!\u0001b\u0019\t\b\u0001"}, strings={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "getABSTRACT_MODIFIER", "()Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "getARRAY_ACCESS", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "getAS_TYPE", "CALL_ELEMENT", "Lcom/intellij/psi/PsiElement;", "getCALL_ELEMENT", "CALL_EXPRESSION", "getCALL_EXPRESSION", "COMPANION_OBJECT", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "getCOMPANION_OBJECT", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "getCUT_CHAR_QUOTES", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getDECLARATION_NAME", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getDECLARATION_RETURN_TYPE", "DECLARATION_SIGNATURE", "getDECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "getDECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "getDECLARATION_WITH_BODY", "DEFAULT", "getDEFAULT", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "getDELEGATOR_SUPER_CALL", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "getELSE_ENTRY", "FINAL_MODIFIER", "getFINAL_MODIFIER", "FOR_REDECLARATION", "getFOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "getFOR_UNRESOLVED_REFERENCE", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getFUNCTION_PARAMETERS", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "getIMPORT_ALIAS", "LONG_LITERAL_SUFFIX", "getLONG_LITERAL_SUFFIX", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "getNULLABLE_TYPE", "OVERRIDE_MODIFIER", "getOVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPARAMETER_DEFAULT_VALUE", "PRIVATE_MODIFIER", "getPRIVATE_MODIFIER", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "getSECONDARY_CONSTRUCTOR_DELEGATION_CALL", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "getTYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNREACHABLE_CODE", "getUNREACHABLE_CODE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "getUNUSED_VALUE", "USELESS_ELVIS", "getUSELESS_ELVIS", "VALUE_ARGUMENTS", "getVALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "getVAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "getVARIANCE_IN_PROJECTION", "VARIANCE_MODIFIER", "getVARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "getVISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "getWHEN_CONDITION_IN_RANGE", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "getWHEN_EXPRESSION", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "DeclarationHeader"}, moduleName="kotlin-compiler")
public final class PositioningStrategies {
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT;
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE;
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> FINAL_MODIFIER;
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> VAL_OR_VAR_NODE;
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> COMPANION_OBJECT;
    @NotNull
    public static final PositioningStrategy<KtConstructorDelegationCall> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    public static final PositioningStrategies INSTANCE;
    public static final PositioningStrategies INSTANCE$;

    @NotNull
    public final PositioningStrategy<PsiElement> getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getDECLARATION_RETURN_TYPE() {
        return DECLARATION_RETURN_TYPE;
    }

    @NotNull
    public final PositioningStrategy<KtNamedDeclaration> getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDECLARATION_SIGNATURE_OR_DEFAULT() {
        return DECLARATION_SIGNATURE_OR_DEFAULT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getTYPE_PARAMETERS_OR_DECLARATION_SIGNATURE() {
        return TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getABSTRACT_MODIFIER() {
        return ABSTRACT_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getOVERRIDE_MODIFIER() {
        return OVERRIDE_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getFINAL_MODIFIER() {
        return FINAL_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getPRIVATE_MODIFIER() {
        return PRIVATE_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getVARIANCE_MODIFIER() {
        return VARIANCE_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getFOR_REDECLARATION() {
        return FOR_REDECLARATION;
    }

    @NotNull
    public final PositioningStrategy<KtReferenceExpression> getFOR_UNRESOLVED_REFERENCE() {
        return FOR_UNRESOLVED_REFERENCE;
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkParameterIsNotNull(tokens, "tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;

            @NotNull
            protected List<TextRange> mark(@NotNull KtModifierListOwner element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtModifierList $receiver = element.getModifierList();
                KtModifierList ktModifierList = $receiver;
                if (ktModifierList == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "No modifier list, but modifier has been found by the analyzer";
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                KtModifierList modifierList = ktModifierList;
                KtModifierKeywordToken[] ktModifierKeywordTokenArray = this.$tokens;
                for (int i = 0; i < ktModifierKeywordTokenArray.length; ++i) {
                    KtModifierKeywordToken token = ktModifierKeywordTokenArray[i];
                    PsiElement element2 = modifierList.getModifier(token);
                    if (element2 == null) continue;
                    return PositioningStrategyKt.markElement(element2);
                }
                throw (Throwable)new IllegalStateException("None of the modifiers is found: " + CollectionsKt.listOf(Arrays.copyOf(this.$tokens, this.$tokens.length)));
            }
            {
                this.$tokens = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public final PositioningStrategy<KtArrayAccessExpression> getARRAY_ACCESS() {
        return ARRAY_ACCESS;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getVISIBILITY_MODIFIER() {
        return VISIBILITY_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtTypeProjection> getVARIANCE_IN_PROJECTION() {
        return VARIANCE_IN_PROJECTION;
    }

    @NotNull
    public final PositioningStrategy<KtParameter> getPARAMETER_DEFAULT_VALUE() {
        return PARAMETER_DEFAULT_VALUE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCALL_ELEMENT() {
        return CALL_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclarationWithBody> getDECLARATION_WITH_BODY() {
        return DECLARATION_WITH_BODY;
    }

    @NotNull
    public final PositioningStrategy<KtNamedDeclaration> getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final PositioningStrategy<KtWhenEntry> getELSE_ENTRY() {
        return ELSE_ENTRY;
    }

    @NotNull
    public final PositioningStrategy<KtWhenExpression> getWHEN_EXPRESSION() {
        return WHEN_EXPRESSION;
    }

    @NotNull
    public final PositioningStrategy<KtWhenConditionInRange> getWHEN_CONDITION_IN_RANGE() {
        return WHEN_CONDITION_IN_RANGE;
    }

    @NotNull
    public final PositioningStrategy<KtNullableType> getNULLABLE_TYPE() {
        return NULLABLE_TYPE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCALL_EXPRESSION() {
        return CALL_EXPRESSION;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getVALUE_ARGUMENTS() {
        return VALUE_ARGUMENTS;
    }

    @NotNull
    public final PositioningStrategy<KtFunction> getFUNCTION_PARAMETERS() {
        return FUNCTION_PARAMETERS;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getCUT_CHAR_QUOTES() {
        return CUT_CHAR_QUOTES;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getLONG_LITERAL_SUFFIX() {
        return LONG_LITERAL_SUFFIX;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getUNREACHABLE_CODE() {
        return UNREACHABLE_CODE;
    }

    @NotNull
    public final PositioningStrategy<KtBinaryExpressionWithTypeRHS> getAS_TYPE() {
        return AS_TYPE;
    }

    @NotNull
    public final PositioningStrategy<KtObjectDeclaration> getCOMPANION_OBJECT() {
        return COMPANION_OBJECT;
    }

    @NotNull
    public final PositioningStrategy<KtConstructorDelegationCall> getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final PositioningStrategy<KtEnumEntry> getDELEGATOR_SUPER_CALL() {
        return DELEGATOR_SUPER_CALL;
    }

    @NotNull
    public final PositioningStrategy<KtBinaryExpression> getUNUSED_VALUE() {
        return UNUSED_VALUE;
    }

    @NotNull
    public final PositioningStrategy<KtBinaryExpression> getUSELESS_ELVIS() {
        return USELESS_ELVIS;
    }

    @NotNull
    public final PositioningStrategy<KtImportDirective> getIMPORT_ALIAS() {
        return IMPORT_ALIAS;
    }

    static {
        new PositioningStrategies();
    }

    private PositioningStrategies() {
        INSTANCE = this;
        INSTANCE$ = this;
        DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof KtObjectLiteralExpression) {
                    KtObjectDeclaration objectDeclaration = ((KtObjectLiteralExpression)element).getObjectDeclaration();
                    PsiElement objectKeyword = objectDeclaration.getObjectKeyword();
                    KtDelegationSpecifierList delegationSpecifierList = objectDeclaration.getDelegationSpecifierList();
                    if (delegationSpecifierList == null) {
                        return PositioningStrategyKt.markElement(objectKeyword);
                    }
                    return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
                }
                if (psiElement2 instanceof KtObjectDeclaration) {
                    PsiElement psiElement3 = ((KtObjectDeclaration)element).getObjectKeyword();
                    PsiElement psiElement4 = ((KtObjectDeclaration)element).getNameIdentifier();
                    if (psiElement4 == null) {
                        psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                    }
                    return PositioningStrategyKt.markRange(psiElement3, psiElement4);
                }
                if (psiElement2 instanceof KtConstructorDelegationCall) {
                    return PositioningStrategies.INSTANCE.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark((KtConstructorDelegationCall)element);
                }
                return super.mark(element);
            }
        };
        DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return PositioningStrategyKt.markElement(this.getElementToMark(element));
            }

            public boolean isValid(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
            }

            /*
             * WARNING - void declaration
             */
            private final PsiElement getElementToMark(KtDeclaration declaration) {
                void nameIdentifierOrPlaceholder;
                void returnTypeRef;
                KtDeclaration ktDeclaration = declaration;
                Pair<KtTypeReference, PsiElement> pair = ktDeclaration instanceof KtCallableDeclaration ? new Pair<KtTypeReference, PsiElement>(((KtCallableDeclaration)declaration).getTypeReference(), ((KtCallableDeclaration)declaration).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair<KtTypeReference, PsiElement>(((KtPropertyAccessor)declaration).getReturnTypeReference(), ((KtPropertyAccessor)declaration).getNamePlaceholder()) : new Pair<Object, Object>(null, null));
                KtTypeReference ktTypeReference = pair.component1();
                PsiElement psiElement2 = pair.component2();
                pair = null;
                if (returnTypeRef != null) {
                    return (PsiElement)returnTypeRef;
                }
                if (nameIdentifierOrPlaceholder != null) {
                    return nameIdentifierOrPlaceholder;
                }
                return declaration;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof KtClassOrObject) {
                        PsiElement psiElement2;
                        PsiElement psiElement3 = ((KtClassOrObject)element).getModifierList();
                        if (psiElement3 == null || (psiElement3 = psiElement3.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                            ASTNode aSTNode = ((KtClassOrObject)element).getNode().findChildByType(TokenSet.create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD));
                            psiElement3 = psiElement2 = aSTNode != null ? aSTNode.getPsi() : null;
                        }
                        if (psiElement3 == null) {
                            psiElement2 = element;
                        }
                        PsiElement startElement = psiElement2;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.INSTANCE.getDEFAULT().mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtConstructor) {
                    PsiElement psiElement2 = ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        psiElement2 = ((KtConstructor)element).getValueParameterList();
                    }
                    if (psiElement2 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement begin = psiElement2;
                    KtParameterList ktParameterList = ((KtConstructor)element).getValueParameterList();
                    PsiElement psiElement3 = ktParameterList != null ? (PsiElement)ktParameterList : ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement3 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement end = psiElement3;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    NavigatablePsiElement navigatablePsiElement;
                    PsiElement endOfSignatureElement;
                    PsiElement psiElement4;
                    KtTypeReference ktTypeReference = ((KtFunction)element).getTypeReference();
                    PsiElement psiElement5 = ktTypeReference != null ? (PsiElement)ktTypeReference : (PsiElement)((KtFunction)element).getValueParameterList();
                    if (psiElement5 == null) {
                        psiElement5 = psiElement4 = ((KtFunction)element).getNameIdentifier();
                    }
                    if (psiElement5 == null) {
                        psiElement4 = endOfSignatureElement = (PsiElement)element;
                    }
                    if (element instanceof KtFunctionLiteral) {
                        KtTypeReference ktTypeReference2 = ((KtFunctionLiteral)element).getReceiverTypeReference();
                        navigatablePsiElement = ktTypeReference2 != null ? (NavigatablePsiElement)ktTypeReference2 : (NavigatablePsiElement)((KtFunctionLiteral)element).getValueParameterList();
                        if (navigatablePsiElement == null) {
                            navigatablePsiElement = element;
                        }
                    } else {
                        navigatablePsiElement = element;
                    }
                    NavigatablePsiElement startElement = navigatablePsiElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    KtTypeReference ktTypeReference = ((KtProperty)element).getTypeReference();
                    PsiElement psiElement6 = ktTypeReference != null ? (PsiElement)ktTypeReference : ((KtProperty)element).getNameIdentifier();
                    if (psiElement6 == null) {
                        psiElement6 = element;
                    }
                    PsiElement endOfSignatureElement = psiElement6;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement7;
                    PsiElement psiElement8;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element).getReturnTypeReference();
                    if (ktTypeReference != null) {
                        psiElement8 = ktTypeReference;
                    } else {
                        ASTNode aSTNode = ((KtPropertyAccessor)element).getRightParenthesis();
                        psiElement8 = psiElement7 = aSTNode != null ? aSTNode.getPsi() : null;
                    }
                    if (psiElement8 == null) {
                        PsiElement psiElement9 = ((KtPropertyAccessor)element).getNamePlaceholder();
                        psiElement7 = psiElement9;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement9, "element.getNamePlaceholder()");
                    }
                    PsiElement endOfSignatureElement = psiElement7;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement psiElement10 = ((KtClass)element).getNameIdentifier();
                    if (psiElement10 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = psiElement10;
                    KtParameterList ktParameterList = ((KtClass)element).getPrimaryConstructorParameterList();
                    if (ktParameterList == null) {
                        PsiElement psiElement11 = nameAsDeclaration;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement11, "nameAsDeclaration");
                        return PositioningStrategyKt.markElement(psiElement11);
                    }
                    KtParameterList primaryConstructorParameterList = ktParameterList;
                    PsiElement psiElement12 = nameAsDeclaration;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement12, "nameAsDeclaration");
                    return PositioningStrategyKt.markRange(psiElement12, primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.INSTANCE.getDECLARATION_NAME().mark((KtNamedDeclaration)element);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark((KtDeclaration)element) : PositioningStrategies.INSTANCE.getDEFAULT().mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().isValid((KtDeclaration)element) : PositioningStrategies.INSTANCE.getDEFAULT().isValid(element);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclaration element) {
                KtTypeParameterList jetTypeParameterList;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtTypeParameterListOwner && (jetTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(jetTypeParameterList);
                }
                return PositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark((KtDeclaration)((PsiElement)element));
            }
        };
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken2, "KtTokens.OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray2[0] = ktModifierKeywordToken2;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray2);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray3 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken3, "KtTokens.FINAL_KEYWORD");
        ktModifierKeywordTokenArray3[0] = ktModifierKeywordToken3;
        FINAL_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray3);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray4 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken4, "KtTokens.PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray4[0] = ktModifierKeywordToken4;
        PRIVATE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray4);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray5 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken5, "KtTokens.IN_KEYWORD");
        ktModifierKeywordTokenArray5[0] = ktModifierKeywordToken5;
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken6, "KtTokens.OUT_KEYWORD");
        ktModifierKeywordTokenArray5[1] = ktModifierKeywordToken6;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray5);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement3 = element;
                if (psiElement3 instanceof KtNamedDeclaration) {
                    psiElement2 = ((KtNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement3 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element).getPackageDirective();
                    if (ktPackageDirective == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement2 = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement2 = nameIdentifier = (PsiElement)null;
                }
                if (nameIdentifier == null && element instanceof KtObjectDeclaration) {
                    return PositioningStrategies.INSTANCE.getDEFAULT().mark(element);
                }
                PsiElement psiElement4 = nameIdentifier;
                if (psiElement4 == null) {
                    psiElement4 = element;
                }
                return PositioningStrategyKt.markElement(psiElement4);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtReferenceExpression element) {
                List<TextRange> ranges2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtArrayAccessExpression && !(ranges2 = ((KtArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                    List<TextRange> list = ranges2;
                    Intrinsics.checkExpressionValueIsNotNull(list, "ranges");
                    return list;
                }
                return CollectionsKt.listOf(KtPsiUtilKt.getCalleeHighlightingRange(element));
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtArrayAccessExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getIndicesNode();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getIndicesNode()");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        VISIBILITY_MODIFIER = new PositioningStrategy<KtModifierListOwner>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<TextRange> mark(@NotNull KtModifierListOwner element) {
                PsiElement psiElement2;
                PsiElement nameIdentifier;
                void destination;
                void $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<KtModifierKeywordToken> visibilityTokens = CollectionsKt.listOf(KtTokens.PRIVATE_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PUBLIC_KEYWORD, KtTokens.INTERNAL_KEYWORD);
                KtModifierList modifierList = element.getModifierList();
                Iterable iterable = visibilityTokens;
                KtModifierListOwner ktModifierListOwner = $receiver2;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (T item : $receiver) {
                    void it;
                    KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)item;
                    void var14_10 = destination;
                    PsiElement psiElement3 = modifierList;
                    TextRange textRange = psiElement3 != null && (psiElement3 = ((KtModifierList)psiElement3).getModifier((KtModifierKeywordToken)it)) != null ? psiElement3.getTextRange() : null;
                    var14_10.add(textRange);
                }
                List<TextRange> result2 = CollectionsKt.filterNotNull((List)destination);
                if (!result2.isEmpty()) {
                    return result2;
                }
                if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                ktModifierListOwner = element;
                if (ktModifierListOwner instanceof KtObjectDeclaration) {
                    psiElement2 = ((KtObjectDeclaration)element).getObjectKeyword();
                } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                    psiElement2 = ((KtPropertyAccessor)element).getNamePlaceholder();
                } else if (ktModifierListOwner instanceof KtClassInitializer) {
                    psiElement2 = element;
                } else {
                    throw (Throwable)new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + "'");
                }
                PsiElement elementToMark = psiElement2;
                return PositioningStrategyKt.markElement(elementToMark);
            }
        };
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtTypeProjection element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getProjectionToken();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getProjectionToken()!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getDefaultValue();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getDefaultValue()!!.getNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                KtElement ktElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element;
                if (!(psiElement2 instanceof KtCallElement)) {
                    psiElement2 = null;
                }
                return PositioningStrategyKt.markElement((ktElement = (KtCallElement)psiElement2) != null && (ktElement = ktElement.getCalleeExpression()) != null ? (PsiElement)ktElement : element);
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                TextRange lastBracketRange = ktBlockExpression != null ? ktBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (!super.isValid((PsiElement)element)) return false;
                KtExpression ktExpression = element.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                if (ktBlockExpression == null) return false;
                TextRange textRange = ktBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtNamedDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                List list;
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtNamedDeclaration ktNamedDeclaration = element;
                if (ktNamedDeclaration instanceof KtParameter) {
                    PsiElement psiElement2 = ((KtParameter)element).getValOrVarKeyword();
                    if (psiElement2 == null) {
                        psiElement2 = element;
                    }
                    list = PositioningStrategyKt.markElement(psiElement2);
                } else if (ktNamedDeclaration instanceof KtProperty) {
                    PsiElement psiElement3 = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement3, "element.valOrVarKeyword");
                    list = PositioningStrategyKt.markElement(psiElement3);
                } else {
                    list = (List)((Object)PreconditionsKt.error("Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element)));
                }
                return list;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtWhenEntry element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getElseKeyword();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getElseKeyword()!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtWhenExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getWhenKeyword()");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtWhenConditionInRange element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getOperationReference()");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtNullableType element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getQuestionMarkNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtCallExpression) {
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element).getTypeArgumentList();
                    PsiElement psiElement2 = ktTypeArgumentList != null ? (PsiElement)ktTypeArgumentList : (PsiElement)((KtCallExpression)element).getCalleeExpression();
                    if (psiElement2 == null) {
                        psiElement2 = element;
                    }
                    return PositioningStrategyKt.markRange(element, psiElement2);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtElement element) {
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtElement ktElement = element;
                if (!(ktElement instanceof KtValueArgumentList)) {
                    ktElement = null;
                }
                if ((psiElement2 = (KtValueArgumentList)ktElement) == null || (psiElement2 = psiElement2.getRightParenthesis()) == null) {
                    psiElement2 = element;
                }
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtFunction element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getLBrace().getNode()");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE_OR_DEFAULT().mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = ((KtConstantExpression)element).getTextRange();
                    return CollectionsKt.listOf(TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    return CollectionsKt.listOf(TextRange.create(endOffset - 1, endOffset));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
                List list = (List)((DiagnosticWithParameters1)Errors.UNREACHABLE_CODE.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull(list, "Errors.UNREACHABLE_CODE.cast(diagnostic).getA()");
                return list;
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getOperationReference()");
                return PositioningStrategyKt.markRange(psiElement2, element);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtObjectDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.hasModifier(KtTokens.COMPANION_KEYWORD)) {
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.COMPANION_KEYWORD");
                    ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray).mark((KtModifierListOwner)((PsiElement)element));
                }
                return PositioningStrategies.INSTANCE.getDEFAULT().mark(element);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<KtConstructorDelegationCall>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtConstructorDelegationCall element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.isImplicit()) {
                    PsiElement $receiver = element;
                    KtSecondaryConstructor ktSecondaryConstructor = PsiTreeUtil.getParentOfType($receiver, KtSecondaryConstructor.class, true);
                    if (ktSecondaryConstructor == null) {
                        Intrinsics.throwNpe();
                    }
                    KtSecondaryConstructor constructor = ktSecondaryConstructor;
                    KtParameterList ktParameterList = constructor.getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(constructor);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement2 = constructor.getConstructorKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement2, "constructor.getConstructorKeyword()");
                    PsiElement psiElement3 = valueParameterList.getLastChild();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement3, "valueParameterList.getLastChild()");
                    return PositioningStrategyKt.markRange(psiElement2, psiElement3);
                }
                KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = element.getCalleeExpression();
                return PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression != null ? (PsiElement)ktConstructorDelegationReferenceExpression : (PsiElement)element);
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtEnumEntry element) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<KtDelegationSpecifier> specifiers = element.getDelegationSpecifiers();
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element;
                } else {
                    KtElementImplStub ktElementImplStub2 = specifiers.get(0);
                    ktElementImplStub = ktElementImplStub2;
                    Intrinsics.checkExpressionValueIsNotNull(ktElementImplStub2, "specifiers[0]");
                }
                return PositioningStrategyKt.markElement(ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getLeft();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(ktExpression), PsiUtilsKt.getEndOffset(element.getOperationReference())));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(element.getOperationReference()), PsiUtilsKt.getEndOffset(element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<TextRange> mark(@NotNull KtImportDirective element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getAliasNameNode();
                if (aSTNode != null) {
                    ASTNode it;
                    ASTNode $receiver = aSTNode;
                    ASTNode aSTNode2 = it = $receiver;
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode2, "it");
                    return PositioningStrategyKt.markNode(aSTNode2);
                }
                KtExpression ktExpression = element.getImportedReference();
                if (ktExpression != null) {
                    KtExpression $receiver = ktExpression;
                    KtExpression it = $receiver;
                    if (it instanceof KtQualifiedExpression) {
                        KtExpression ktExpression2 = ((KtQualifiedExpression)it).getSelectorExpression();
                        if (ktExpression2 != null) {
                            void $receiver2;
                            KtExpression $i$a$1 = ktExpression2;
                            KtExpression it2 = (KtExpression)$receiver2;
                            PsiElement psiElement2 = it2;
                            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "it");
                            return PositioningStrategyKt.markElement(psiElement2);
                        }
                    }
                    PsiElement psiElement3 = it;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement3, "it");
                    return PositioningStrategyKt.markElement(psiElement3);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0005\u00131\u0001Q\u0003\u0002\u0003\u0001\u0011\u0003)\u0012\u0001G\u0001\u001a\t%\u0011\u0011\"\u0001S\u00011\u0007\t+!U\u0002\u0002\u0011\t)+\u0002B\u0006\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\b\u0001R\u0007\u0005AA\u0001"}, strings={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z"}, moduleName="kotlin-compiler")
    private static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            if (element instanceof KtNamedDeclaration && !(element instanceof KtObjectDeclaration) && !(element instanceof KtSecondaryConstructor) && !(element instanceof KtFunction) && ((KtNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }
}

