/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.clean.ReferenceTracker;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tA!\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u0005\u0005\u0003!-Q\"\u0001\r\u00073\rAi!D\u0001\u0019\u000f\u0015rAa\u0003E\b\u001b\u0005Ab!G\u0002\t\u00115\t\u0001\u0014C\r\u0006\u0011%i1!C\u0001\u0005\u0004aMQE\u0004\u0003\f\u0011\u001fi\u0011\u0001\u0007\u0004\u001a\u0007!AQ\"\u0001\r\b3\u0015A\u0011\"D\u0002\n\u0003\u0011\r\u00014C\u0015\u000e\t\rC\u00012A\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005q\u0019\u0013kA\u0002\u000e\u0005\u0011\u0019\u0001rA\u0015\u000e\t\u0005C\u0001\u0002B\u0007\b\u0013\tI\u0011\u0001G\u0003\n\u0005%\t\u0001T\u0001M\u0005#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/clean/UnusedInstanceCollector;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "()V", "removableDeclarations", "", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "getRemovableDeclarations", "()Ljava/util/List;", "tracker", "Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "isLocalFunctionDeclaration", "", "jsVar", "Lcom/google/dart/compiler/backend/js/ast/JsVars$JsVar;", "visit", "x", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;"}, moduleName="kotlin-compiler")
public final class UnusedInstanceCollector
extends JsVisitorWithContextImpl {
    private final ReferenceTracker<JsName, JsStatement> tracker = new ReferenceTracker();

    @NotNull
    public final List<JsStatement> getRemovableDeclarations() {
        return this.tracker.getRemovable();
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        void $receiver;
        JsStatement currentStatement;
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        if (!this.isLocalFunctionDeclaration(x)) {
            return super.visit(x, ctx);
        }
        JsName jsName = x.getName();
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsName name = jsName;
        JsContext<JsStatement> statementContext = this.getLastStatementLevelContext();
        JsStatement jsStatement = currentStatement = statementContext.getCurrentNode();
        if (jsStatement == null) {
            Intrinsics.throwNpe();
        }
        JsNode jsNode = jsStatement;
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "currentStatement!!");
        this.tracker.addCandidateForRemoval(name, (JsStatement)jsNode);
        List<JsName> references = CollectUtilsKt.collectReferencesInside(x);
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)references);
        for (Object element : $receiver) {
            JsName it = (JsName)element;
            this.tracker.addRemovableReference(name, it);
        }
        return false;
    }

    public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsName name = x.getName();
        if (name != null) {
            this.tracker.markReachable(name);
        }
        return false;
    }

    private final boolean isLocalFunctionDeclaration(JsVars.JsVar jsVar) {
        JsName name = jsVar.getName();
        JsExpression expr = jsVar.getInitExpression();
        JsName jsName = name;
        JsNode staticRef2 = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
        return staticRef2 != null && Intrinsics.areEqual(staticRef2, expr);
    }
}

